/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The ReadinessCheck to create
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReadinessCheckRequest extends Route53RecoveryReadinessRequest implements
        ToCopyableBuilder<CreateReadinessCheckRequest.Builder, CreateReadinessCheckRequest> {
    private static final SdkField<String> READINESS_CHECK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReadinessCheckName").getter(getter(CreateReadinessCheckRequest::readinessCheckName))
            .setter(setter(Builder::readinessCheckName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readinessCheckName").build())
            .build();

    private static final SdkField<String> RESOURCE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceSetName").getter(getter(CreateReadinessCheckRequest::resourceSetName))
            .setter(setter(Builder::resourceSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSetName").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateReadinessCheckRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READINESS_CHECK_NAME_FIELD,
            RESOURCE_SET_NAME_FIELD, TAGS_FIELD));

    private final String readinessCheckName;

    private final String resourceSetName;

    private final Map<String, String> tags;

    private CreateReadinessCheckRequest(BuilderImpl builder) {
        super(builder);
        this.readinessCheckName = builder.readinessCheckName;
        this.resourceSetName = builder.resourceSetName;
        this.tags = builder.tags;
    }

    /**
     * The name of the ReadinessCheck to create
     * 
     * @return The name of the ReadinessCheck to create
     */
    public final String readinessCheckName() {
        return readinessCheckName;
    }

    /**
     * The name of the ResourceSet to check
     * 
     * @return The name of the ResourceSet to check
     */
    public final String resourceSetName() {
        return resourceSetName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(readinessCheckName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSetName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReadinessCheckRequest)) {
            return false;
        }
        CreateReadinessCheckRequest other = (CreateReadinessCheckRequest) obj;
        return Objects.equals(readinessCheckName(), other.readinessCheckName())
                && Objects.equals(resourceSetName(), other.resourceSetName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReadinessCheckRequest").add("ReadinessCheckName", readinessCheckName())
                .add("ResourceSetName", resourceSetName()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReadinessCheckName":
            return Optional.ofNullable(clazz.cast(readinessCheckName()));
        case "ResourceSetName":
            return Optional.ofNullable(clazz.cast(resourceSetName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReadinessCheckRequest, T> g) {
        return obj -> g.apply((CreateReadinessCheckRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryReadinessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateReadinessCheckRequest> {
        /**
         * The name of the ReadinessCheck to create
         * 
         * @param readinessCheckName
         *        The name of the ReadinessCheck to create
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readinessCheckName(String readinessCheckName);

        /**
         * The name of the ResourceSet to check
         * 
         * @param resourceSetName
         *        The name of the ResourceSet to check
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSetName(String resourceSetName);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53RecoveryReadinessRequest.BuilderImpl implements Builder {
        private String readinessCheckName;

        private String resourceSetName;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReadinessCheckRequest model) {
            super(model);
            readinessCheckName(model.readinessCheckName);
            resourceSetName(model.resourceSetName);
            tags(model.tags);
        }

        public final String getReadinessCheckName() {
            return readinessCheckName;
        }

        public final void setReadinessCheckName(String readinessCheckName) {
            this.readinessCheckName = readinessCheckName;
        }

        @Override
        @Transient
        public final Builder readinessCheckName(String readinessCheckName) {
            this.readinessCheckName = readinessCheckName;
            return this;
        }

        public final String getResourceSetName() {
            return resourceSetName;
        }

        public final void setResourceSetName(String resourceSetName) {
            this.resourceSetName = resourceSetName;
        }

        @Override
        @Transient
        public final Builder resourceSetName(String resourceSetName) {
            this.resourceSetName = resourceSetName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReadinessCheckRequest build() {
            return new CreateReadinessCheckRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
