/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReadinessCheckResourceStatusResponse extends Route53RecoveryReadinessResponse implements
        ToCopyableBuilder<GetReadinessCheckResourceStatusResponse.Builder, GetReadinessCheckResourceStatusResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetReadinessCheckResourceStatusResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> READINESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Readiness").getter(getter(GetReadinessCheckResourceStatusResponse::readinessAsString))
            .setter(setter(Builder::readiness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readiness").build()).build();

    private static final SdkField<List<RuleResult>> RULES_FIELD = SdkField
            .<List<RuleResult>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(GetReadinessCheckResourceStatusResponse::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            READINESS_FIELD, RULES_FIELD));

    private final String nextToken;

    private final String readiness;

    private final List<RuleResult> rules;

    private GetReadinessCheckResourceStatusResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.readiness = builder.readiness;
        this.rules = builder.rules;
    }

    /**
     * A token that can be used to resume pagination from the end of the collection.
     * 
     * @return A token that can be used to resume pagination from the end of the collection.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * The readiness at rule level.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #readiness} will
     * return {@link Readiness#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #readinessAsString}.
     * </p>
     * 
     * @return The readiness at rule level.
     * @see Readiness
     */
    public final Readiness readiness() {
        return Readiness.fromValue(readiness);
    }

    /**
     * The readiness at rule level.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #readiness} will
     * return {@link Readiness#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #readinessAsString}.
     * </p>
     * 
     * @return The readiness at rule level.
     * @see Readiness
     */
    public final String readinessAsString() {
        return readiness;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * Details of the rules's results
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return Details of the rules's results
     */
    public final List<RuleResult> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(readinessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReadinessCheckResourceStatusResponse)) {
            return false;
        }
        GetReadinessCheckResourceStatusResponse other = (GetReadinessCheckResourceStatusResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(readinessAsString(), other.readinessAsString())
                && hasRules() == other.hasRules() && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReadinessCheckResourceStatusResponse").add("NextToken", nextToken())
                .add("Readiness", readinessAsString()).add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Readiness":
            return Optional.ofNullable(clazz.cast(readinessAsString()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReadinessCheckResourceStatusResponse, T> g) {
        return obj -> g.apply((GetReadinessCheckResourceStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryReadinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetReadinessCheckResourceStatusResponse> {
        /**
         * A token that can be used to resume pagination from the end of the collection.
         * 
         * @param nextToken
         *        A token that can be used to resume pagination from the end of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * The readiness at rule level.
         * 
         * @param readiness
         *        The readiness at rule level.
         * @see Readiness
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Readiness
         */
        Builder readiness(String readiness);

        /**
         * The readiness at rule level.
         * 
         * @param readiness
         *        The readiness at rule level.
         * @see Readiness
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Readiness
         */
        Builder readiness(Readiness readiness);

        /**
         * Details of the rules's results
         * 
         * @param rules
         *        Details of the rules's results
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<RuleResult> rules);

        /**
         * Details of the rules's results
         * 
         * @param rules
         *        Details of the rules's results
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(RuleResult... rules);

        /**
         * Details of the rules's results This is a convenience that creates an instance of the {@link List
         * <RuleResult>.Builder} avoiding the need to create one manually via {@link List<RuleResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RuleResult>.Builder#build()} is called immediately and its
         * result is passed to {@link #rules(List<RuleResult>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<RuleResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<RuleResult>)
         */
        Builder rules(Consumer<RuleResult.Builder>... rules);
    }

    static final class BuilderImpl extends Route53RecoveryReadinessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private String readiness;

        private List<RuleResult> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetReadinessCheckResourceStatusResponse model) {
            super(model);
            nextToken(model.nextToken);
            readiness(model.readiness);
            rules(model.rules);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getReadiness() {
            return readiness;
        }

        public final void setReadiness(String readiness) {
            this.readiness = readiness;
        }

        @Override
        @Transient
        public final Builder readiness(String readiness) {
            this.readiness = readiness;
            return this;
        }

        @Override
        @Transient
        public final Builder readiness(Readiness readiness) {
            this.readiness(readiness == null ? null : readiness.toString());
            return this;
        }

        public final List<RuleResult.Builder> getRules() {
            List<RuleResult.Builder> result = ___listOfRuleResultCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<RuleResult.BuilderImpl> rules) {
            this.rules = ___listOfRuleResultCopier.copyFromBuilder(rules);
        }

        @Override
        @Transient
        public final Builder rules(Collection<RuleResult> rules) {
            this.rules = ___listOfRuleResultCopier.copy(rules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rules(RuleResult... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rules(Consumer<RuleResult.Builder>... rules) {
            rules(Stream.of(rules).map(c -> RuleResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetReadinessCheckResourceStatusResponse build() {
            return new GetReadinessCheckResourceStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
