/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReadinessCheckStatusResponse extends Route53RecoveryReadinessResponse implements
        ToCopyableBuilder<GetReadinessCheckStatusResponse.Builder, GetReadinessCheckStatusResponse> {
    private static final SdkField<List<Message>> MESSAGES_FIELD = SdkField
            .<List<Message>> builder(MarshallingType.LIST)
            .memberName("Messages")
            .getter(getter(GetReadinessCheckStatusResponse::messages))
            .setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Message> builder(MarshallingType.SDK_POJO)
                                            .constructor(Message::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetReadinessCheckStatusResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> READINESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Readiness").getter(getter(GetReadinessCheckStatusResponse::readinessAsString))
            .setter(setter(Builder::readiness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readiness").build()).build();

    private static final SdkField<List<ResourceResult>> RESOURCES_FIELD = SdkField
            .<List<ResourceResult>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(GetReadinessCheckStatusResponse::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGES_FIELD,
            NEXT_TOKEN_FIELD, READINESS_FIELD, RESOURCES_FIELD));

    private final List<Message> messages;

    private final String nextToken;

    private final String readiness;

    private final List<ResourceResult> resources;

    private GetReadinessCheckStatusResponse(BuilderImpl builder) {
        super(builder);
        this.messages = builder.messages;
        this.nextToken = builder.nextToken;
        this.readiness = builder.readiness;
        this.resources = builder.resources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Messages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMessages() {
        return messages != null && !(messages instanceof SdkAutoConstructList);
    }

    /**
     * Top level messages for readiness check status
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessages} method.
     * </p>
     * 
     * @return Top level messages for readiness check status
     */
    public final List<Message> messages() {
        return messages;
    }

    /**
     * A token that can be used to resume pagination from the end of the collection.
     * 
     * @return A token that can be used to resume pagination from the end of the collection.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * The readiness at rule level.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #readiness} will
     * return {@link Readiness#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #readinessAsString}.
     * </p>
     * 
     * @return The readiness at rule level.
     * @see Readiness
     */
    public final Readiness readiness() {
        return Readiness.fromValue(readiness);
    }

    /**
     * The readiness at rule level.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #readiness} will
     * return {@link Readiness#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #readinessAsString}.
     * </p>
     * 
     * @return The readiness at rule level.
     * @see Readiness
     */
    public final String readinessAsString() {
        return readiness;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * Summary of resources's readiness
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return Summary of resources's readiness
     */
    public final List<ResourceResult> resources() {
        return resources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMessages() ? messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(readinessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReadinessCheckStatusResponse)) {
            return false;
        }
        GetReadinessCheckStatusResponse other = (GetReadinessCheckStatusResponse) obj;
        return hasMessages() == other.hasMessages() && Objects.equals(messages(), other.messages())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(readinessAsString(), other.readinessAsString()) && hasResources() == other.hasResources()
                && Objects.equals(resources(), other.resources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReadinessCheckStatusResponse").add("Messages", hasMessages() ? messages() : null)
                .add("NextToken", nextToken()).add("Readiness", readinessAsString())
                .add("Resources", hasResources() ? resources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Messages":
            return Optional.ofNullable(clazz.cast(messages()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Readiness":
            return Optional.ofNullable(clazz.cast(readinessAsString()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReadinessCheckStatusResponse, T> g) {
        return obj -> g.apply((GetReadinessCheckStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryReadinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetReadinessCheckStatusResponse> {
        /**
         * Top level messages for readiness check status
         * 
         * @param messages
         *        Top level messages for readiness check status
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<Message> messages);

        /**
         * Top level messages for readiness check status
         * 
         * @param messages
         *        Top level messages for readiness check status
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Message... messages);

        /**
         * Top level messages for readiness check status This is a convenience that creates an instance of the
         * {@link List<Message>.Builder} avoiding the need to create one manually via {@link List<Message>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Message>.Builder#build()} is called immediately and its
         * result is passed to {@link #messages(List<Message>)}.
         * 
         * @param messages
         *        a consumer that will call methods on {@link List<Message>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(List<Message>)
         */
        Builder messages(Consumer<Message.Builder>... messages);

        /**
         * A token that can be used to resume pagination from the end of the collection.
         * 
         * @param nextToken
         *        A token that can be used to resume pagination from the end of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * The readiness at rule level.
         * 
         * @param readiness
         *        The readiness at rule level.
         * @see Readiness
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Readiness
         */
        Builder readiness(String readiness);

        /**
         * The readiness at rule level.
         * 
         * @param readiness
         *        The readiness at rule level.
         * @see Readiness
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Readiness
         */
        Builder readiness(Readiness readiness);

        /**
         * Summary of resources's readiness
         * 
         * @param resources
         *        Summary of resources's readiness
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<ResourceResult> resources);

        /**
         * Summary of resources's readiness
         * 
         * @param resources
         *        Summary of resources's readiness
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(ResourceResult... resources);

        /**
         * Summary of resources's readiness This is a convenience that creates an instance of the {@link List
         * <ResourceResult>.Builder} avoiding the need to create one manually via {@link List<ResourceResult>#builder()}
         * .
         *
         * When the {@link Consumer} completes, {@link List<ResourceResult>.Builder#build()} is called immediately and
         * its result is passed to {@link #resources(List<ResourceResult>)}.
         * 
         * @param resources
         *        a consumer that will call methods on {@link List<ResourceResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(List<ResourceResult>)
         */
        Builder resources(Consumer<ResourceResult.Builder>... resources);
    }

    static final class BuilderImpl extends Route53RecoveryReadinessResponse.BuilderImpl implements Builder {
        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String readiness;

        private List<ResourceResult> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetReadinessCheckStatusResponse model) {
            super(model);
            messages(model.messages);
            nextToken(model.nextToken);
            readiness(model.readiness);
            resources(model.resources);
        }

        public final List<Message.Builder> getMessages() {
            List<Message.Builder> result = ___listOfMessageCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = ___listOfMessageCopier.copyFromBuilder(messages);
        }

        @Override
        @Transient
        public final Builder messages(Collection<Message> messages) {
            this.messages = ___listOfMessageCopier.copy(messages);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder messages(Message... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder>... messages) {
            messages(Stream.of(messages).map(c -> Message.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getReadiness() {
            return readiness;
        }

        public final void setReadiness(String readiness) {
            this.readiness = readiness;
        }

        @Override
        @Transient
        public final Builder readiness(String readiness) {
            this.readiness = readiness;
            return this;
        }

        @Override
        @Transient
        public final Builder readiness(Readiness readiness) {
            this.readiness(readiness == null ? null : readiness.toString());
            return this;
        }

        public final List<ResourceResult.Builder> getResources() {
            List<ResourceResult.Builder> result = ___listOfResourceResultCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<ResourceResult.BuilderImpl> resources) {
            this.resources = ___listOfResourceResultCopier.copyFromBuilder(resources);
        }

        @Override
        @Transient
        public final Builder resources(Collection<ResourceResult> resources) {
            this.resources = ___listOfResourceResultCopier.copy(resources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resources(ResourceResult... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resources(Consumer<ResourceResult.Builder>... resources) {
            resources(Stream.of(resources).map(c -> ResourceResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetReadinessCheckStatusResponse build() {
            return new GetReadinessCheckStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
