/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCrossAccountAuthorizationsResponse extends Route53RecoveryReadinessResponse implements
        ToCopyableBuilder<ListCrossAccountAuthorizationsResponse.Builder, ListCrossAccountAuthorizationsResponse> {
    private static final SdkField<List<String>> CROSS_ACCOUNT_AUTHORIZATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CrossAccountAuthorizations")
            .getter(getter(ListCrossAccountAuthorizationsResponse::crossAccountAuthorizations))
            .setter(setter(Builder::crossAccountAuthorizations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossAccountAuthorizations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCrossAccountAuthorizationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CROSS_ACCOUNT_AUTHORIZATIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> crossAccountAuthorizations;

    private final String nextToken;

    private ListCrossAccountAuthorizationsResponse(BuilderImpl builder) {
        super(builder);
        this.crossAccountAuthorizations = builder.crossAccountAuthorizations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CrossAccountAuthorizations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCrossAccountAuthorizations() {
        return crossAccountAuthorizations != null && !(crossAccountAuthorizations instanceof SdkAutoConstructList);
    }

    /**
     * A list of CrossAccountAuthorizations
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCrossAccountAuthorizations} method.
     * </p>
     * 
     * @return A list of CrossAccountAuthorizations
     */
    public final List<String> crossAccountAuthorizations() {
        return crossAccountAuthorizations;
    }

    /**
     * A token that can be used to resume pagination from the end of the collection.
     * 
     * @return A token that can be used to resume pagination from the end of the collection.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCrossAccountAuthorizations() ? crossAccountAuthorizations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCrossAccountAuthorizationsResponse)) {
            return false;
        }
        ListCrossAccountAuthorizationsResponse other = (ListCrossAccountAuthorizationsResponse) obj;
        return hasCrossAccountAuthorizations() == other.hasCrossAccountAuthorizations()
                && Objects.equals(crossAccountAuthorizations(), other.crossAccountAuthorizations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCrossAccountAuthorizationsResponse")
                .add("CrossAccountAuthorizations", hasCrossAccountAuthorizations() ? crossAccountAuthorizations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrossAccountAuthorizations":
            return Optional.ofNullable(clazz.cast(crossAccountAuthorizations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCrossAccountAuthorizationsResponse, T> g) {
        return obj -> g.apply((ListCrossAccountAuthorizationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryReadinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCrossAccountAuthorizationsResponse> {
        /**
         * A list of CrossAccountAuthorizations
         * 
         * @param crossAccountAuthorizations
         *        A list of CrossAccountAuthorizations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountAuthorizations(Collection<String> crossAccountAuthorizations);

        /**
         * A list of CrossAccountAuthorizations
         * 
         * @param crossAccountAuthorizations
         *        A list of CrossAccountAuthorizations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountAuthorizations(String... crossAccountAuthorizations);

        /**
         * A token that can be used to resume pagination from the end of the collection.
         * 
         * @param nextToken
         *        A token that can be used to resume pagination from the end of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Route53RecoveryReadinessResponse.BuilderImpl implements Builder {
        private List<String> crossAccountAuthorizations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCrossAccountAuthorizationsResponse model) {
            super(model);
            crossAccountAuthorizations(model.crossAccountAuthorizations);
            nextToken(model.nextToken);
        }

        public final Collection<String> getCrossAccountAuthorizations() {
            if (crossAccountAuthorizations instanceof SdkAutoConstructList) {
                return null;
            }
            return crossAccountAuthorizations;
        }

        public final void setCrossAccountAuthorizations(Collection<String> crossAccountAuthorizations) {
            this.crossAccountAuthorizations = ___listOfCrossAccountAuthorizationCopier.copy(crossAccountAuthorizations);
        }

        @Override
        @Transient
        public final Builder crossAccountAuthorizations(Collection<String> crossAccountAuthorizations) {
            this.crossAccountAuthorizations = ___listOfCrossAccountAuthorizationCopier.copy(crossAccountAuthorizations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder crossAccountAuthorizations(String... crossAccountAuthorizations) {
            crossAccountAuthorizations(Arrays.asList(crossAccountAuthorizations));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCrossAccountAuthorizationsResponse build() {
            return new ListCrossAccountAuthorizationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
