/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Result with status for an individual resource.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceResult implements SdkPojo, Serializable, ToCopyableBuilder<ResourceResult.Builder, ResourceResult> {
    private static final SdkField<String> COMPONENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentId").getter(getter(ResourceResult::componentId)).setter(setter(Builder::componentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentId").build()).build();

    private static final SdkField<Instant> LAST_CHECKED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastCheckedTimestamp")
            .getter(getter(ResourceResult::lastCheckedTimestamp))
            .setter(setter(Builder::lastCheckedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastCheckedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> READINESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Readiness").getter(getter(ResourceResult::readinessAsString)).setter(setter(Builder::readiness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readiness").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(ResourceResult::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_ID_FIELD,
            LAST_CHECKED_TIMESTAMP_FIELD, READINESS_FIELD, RESOURCE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String componentId;

    private final Instant lastCheckedTimestamp;

    private final String readiness;

    private final String resourceArn;

    private ResourceResult(BuilderImpl builder) {
        this.componentId = builder.componentId;
        this.lastCheckedTimestamp = builder.lastCheckedTimestamp;
        this.readiness = builder.readiness;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * The component id of the resource
     * 
     * @return The component id of the resource
     */
    public final String componentId() {
        return componentId;
    }

    /**
     * The time the resource was last checked for readiness, in ISO-8601 format, UTC.
     * 
     * @return The time the resource was last checked for readiness, in ISO-8601 format, UTC.
     */
    public final Instant lastCheckedTimestamp() {
        return lastCheckedTimestamp;
    }

    /**
     * The readiness of the resource.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #readiness} will
     * return {@link Readiness#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #readinessAsString}.
     * </p>
     * 
     * @return The readiness of the resource.
     * @see Readiness
     */
    public final Readiness readiness() {
        return Readiness.fromValue(readiness);
    }

    /**
     * The readiness of the resource.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #readiness} will
     * return {@link Readiness#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #readinessAsString}.
     * </p>
     * 
     * @return The readiness of the resource.
     * @see Readiness
     */
    public final String readinessAsString() {
        return readiness;
    }

    /**
     * The ARN of the resource
     * 
     * @return The ARN of the resource
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentId());
        hashCode = 31 * hashCode + Objects.hashCode(lastCheckedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(readinessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceResult)) {
            return false;
        }
        ResourceResult other = (ResourceResult) obj;
        return Objects.equals(componentId(), other.componentId())
                && Objects.equals(lastCheckedTimestamp(), other.lastCheckedTimestamp())
                && Objects.equals(readinessAsString(), other.readinessAsString())
                && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceResult").add("ComponentId", componentId())
                .add("LastCheckedTimestamp", lastCheckedTimestamp()).add("Readiness", readinessAsString())
                .add("ResourceArn", resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComponentId":
            return Optional.ofNullable(clazz.cast(componentId()));
        case "LastCheckedTimestamp":
            return Optional.ofNullable(clazz.cast(lastCheckedTimestamp()));
        case "Readiness":
            return Optional.ofNullable(clazz.cast(readinessAsString()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceResult, T> g) {
        return obj -> g.apply((ResourceResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceResult> {
        /**
         * The component id of the resource
         * 
         * @param componentId
         *        The component id of the resource
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentId(String componentId);

        /**
         * The time the resource was last checked for readiness, in ISO-8601 format, UTC.
         * 
         * @param lastCheckedTimestamp
         *        The time the resource was last checked for readiness, in ISO-8601 format, UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastCheckedTimestamp(Instant lastCheckedTimestamp);

        /**
         * The readiness of the resource.
         * 
         * @param readiness
         *        The readiness of the resource.
         * @see Readiness
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Readiness
         */
        Builder readiness(String readiness);

        /**
         * The readiness of the resource.
         * 
         * @param readiness
         *        The readiness of the resource.
         * @see Readiness
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Readiness
         */
        Builder readiness(Readiness readiness);

        /**
         * The ARN of the resource
         * 
         * @param resourceArn
         *        The ARN of the resource
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);
    }

    static final class BuilderImpl implements Builder {
        private String componentId;

        private Instant lastCheckedTimestamp;

        private String readiness;

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceResult model) {
            componentId(model.componentId);
            lastCheckedTimestamp(model.lastCheckedTimestamp);
            readiness(model.readiness);
            resourceArn(model.resourceArn);
        }

        public final String getComponentId() {
            return componentId;
        }

        public final void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        @Override
        @Transient
        public final Builder componentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        public final Instant getLastCheckedTimestamp() {
            return lastCheckedTimestamp;
        }

        public final void setLastCheckedTimestamp(Instant lastCheckedTimestamp) {
            this.lastCheckedTimestamp = lastCheckedTimestamp;
        }

        @Override
        @Transient
        public final Builder lastCheckedTimestamp(Instant lastCheckedTimestamp) {
            this.lastCheckedTimestamp = lastCheckedTimestamp;
            return this;
        }

        public final String getReadiness() {
            return readiness;
        }

        public final void setReadiness(String readiness) {
            this.readiness = readiness;
        }

        @Override
        @Transient
        public final Builder readiness(String readiness) {
            this.readiness = readiness;
            return this;
        }

        @Override
        @Transient
        public final Builder readiness(Readiness readiness) {
            this.readiness(readiness == null ? null : readiness.toString());
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public ResourceResult build() {
            return new ResourceResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
