/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessAsyncClient;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListReadinessChecksRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListReadinessChecksResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ReadinessCheckOutput;

public class ListReadinessChecksPublisher
implements SdkPublisher<ListReadinessChecksResponse> {
    private final Route53RecoveryReadinessAsyncClient client;
    private final ListReadinessChecksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReadinessChecksPublisher(Route53RecoveryReadinessAsyncClient client, ListReadinessChecksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReadinessChecksPublisher(Route53RecoveryReadinessAsyncClient client, ListReadinessChecksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReadinessChecksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReadinessChecksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReadinessCheckOutput> readinessChecks() {
        Function<ListReadinessChecksResponse, Iterator> getIterator = response -> {
            if (response != null && response.readinessChecks() != null) {
                return response.readinessChecks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReadinessChecksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReadinessChecksResponseFetcher
    implements AsyncPageFetcher<ListReadinessChecksResponse> {
        private ListReadinessChecksResponseFetcher() {
        }

        public boolean hasNextPage(ListReadinessChecksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReadinessChecksResponse> nextPage(ListReadinessChecksResponse previousPage) {
            if (previousPage == null) {
                return ListReadinessChecksPublisher.this.client.listReadinessChecks(ListReadinessChecksPublisher.this.firstRequest);
            }
            return ListReadinessChecksPublisher.this.client.listReadinessChecks((ListReadinessChecksRequest)((Object)ListReadinessChecksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

