/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53recoveryreadiness.model.TargetResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DNSTargetResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DNSTargetResource> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DNSTargetResource.getter(DNSTargetResource::domainName)).setter(DNSTargetResource.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> HOSTED_ZONE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneArn").getter(DNSTargetResource.getter(DNSTargetResource::hostedZoneArn)).setter(DNSTargetResource.setter(Builder::hostedZoneArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostedZoneArn").build()}).build();
    private static final SdkField<String> RECORD_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordSetId").getter(DNSTargetResource.getter(DNSTargetResource::recordSetId)).setter(DNSTargetResource.setter(Builder::recordSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordSetId").build()}).build();
    private static final SdkField<String> RECORD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordType").getter(DNSTargetResource.getter(DNSTargetResource::recordType)).setter(DNSTargetResource.setter(Builder::recordType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordType").build()}).build();
    private static final SdkField<TargetResource> TARGET_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetResource").getter(DNSTargetResource.getter(DNSTargetResource::targetResource)).setter(DNSTargetResource.setter(Builder::targetResource)).constructor(TargetResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, HOSTED_ZONE_ARN_FIELD, RECORD_SET_ID_FIELD, RECORD_TYPE_FIELD, TARGET_RESOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DNSTargetResource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String hostedZoneArn;
    private final String recordSetId;
    private final String recordType;
    private final TargetResource targetResource;

    private DNSTargetResource(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.hostedZoneArn = builder.hostedZoneArn;
        this.recordSetId = builder.recordSetId;
        this.recordType = builder.recordType;
        this.targetResource = builder.targetResource;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String hostedZoneArn() {
        return this.hostedZoneArn;
    }

    public final String recordSetId() {
        return this.recordSetId;
    }

    public final String recordType() {
        return this.recordType;
    }

    public final TargetResource targetResource() {
        return this.targetResource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordType());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DNSTargetResource)) {
            return false;
        }
        DNSTargetResource other = (DNSTargetResource)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.hostedZoneArn(), other.hostedZoneArn()) && Objects.equals(this.recordSetId(), other.recordSetId()) && Objects.equals(this.recordType(), other.recordType()) && Objects.equals(this.targetResource(), other.targetResource());
    }

    public final String toString() {
        return ToString.builder((String)"DNSTargetResource").add("DomainName", (Object)this.domainName()).add("HostedZoneArn", (Object)this.hostedZoneArn()).add("RecordSetId", (Object)this.recordSetId()).add("RecordType", (Object)this.recordType()).add("TargetResource", (Object)this.targetResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "HostedZoneArn": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneArn()));
            }
            case "RecordSetId": {
                return Optional.ofNullable(clazz.cast(this.recordSetId()));
            }
            case "RecordType": {
                return Optional.ofNullable(clazz.cast(this.recordType()));
            }
            case "TargetResource": {
                return Optional.ofNullable(clazz.cast(this.targetResource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("hostedZoneArn", HOSTED_ZONE_ARN_FIELD);
        map.put("recordSetId", RECORD_SET_ID_FIELD);
        map.put("recordType", RECORD_TYPE_FIELD);
        map.put("targetResource", TARGET_RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DNSTargetResource, T> g) {
        return obj -> g.apply((DNSTargetResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String hostedZoneArn;
        private String recordSetId;
        private String recordType;
        private TargetResource targetResource;

        private BuilderImpl() {
        }

        private BuilderImpl(DNSTargetResource model) {
            this.domainName(model.domainName);
            this.hostedZoneArn(model.hostedZoneArn);
            this.recordSetId(model.recordSetId);
            this.recordType(model.recordType);
            this.targetResource(model.targetResource);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getHostedZoneArn() {
            return this.hostedZoneArn;
        }

        public final void setHostedZoneArn(String hostedZoneArn) {
            this.hostedZoneArn = hostedZoneArn;
        }

        @Override
        public final Builder hostedZoneArn(String hostedZoneArn) {
            this.hostedZoneArn = hostedZoneArn;
            return this;
        }

        public final String getRecordSetId() {
            return this.recordSetId;
        }

        public final void setRecordSetId(String recordSetId) {
            this.recordSetId = recordSetId;
        }

        @Override
        public final Builder recordSetId(String recordSetId) {
            this.recordSetId = recordSetId;
            return this;
        }

        public final String getRecordType() {
            return this.recordType;
        }

        public final void setRecordType(String recordType) {
            this.recordType = recordType;
        }

        @Override
        public final Builder recordType(String recordType) {
            this.recordType = recordType;
            return this;
        }

        public final TargetResource.Builder getTargetResource() {
            return this.targetResource != null ? this.targetResource.toBuilder() : null;
        }

        public final void setTargetResource(TargetResource.BuilderImpl targetResource) {
            this.targetResource = targetResource != null ? targetResource.build() : null;
        }

        @Override
        public final Builder targetResource(TargetResource targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        public DNSTargetResource build() {
            return new DNSTargetResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DNSTargetResource> {
        public Builder domainName(String var1);

        public Builder hostedZoneArn(String var1);

        public Builder recordSetId(String var1);

        public Builder recordType(String var1);

        public Builder targetResource(TargetResource var1);

        default public Builder targetResource(Consumer<TargetResource.Builder> targetResource) {
            return this.targetResource((TargetResource)((TargetResource.Builder)TargetResource.builder().applyMutation(targetResource)).build());
        }
    }
}

