/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessClient;
import software.amazon.awssdk.services.route53recoveryreadiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListRecoveryGroupsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListRecoveryGroupsResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.RecoveryGroupOutput;

public class ListRecoveryGroupsIterable
implements SdkIterable<ListRecoveryGroupsResponse> {
    private final Route53RecoveryReadinessClient client;
    private final ListRecoveryGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecoveryGroupsIterable(Route53RecoveryReadinessClient client, ListRecoveryGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRecoveryGroupsResponseFetcher();
    }

    public Iterator<ListRecoveryGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecoveryGroupOutput> recoveryGroups() {
        Function<ListRecoveryGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.recoveryGroups() != null) {
                return response.recoveryGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRecoveryGroupsResponseFetcher
    implements SyncPageFetcher<ListRecoveryGroupsResponse> {
        private ListRecoveryGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecoveryGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecoveryGroupsResponse nextPage(ListRecoveryGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListRecoveryGroupsIterable.this.client.listRecoveryGroups(ListRecoveryGroupsIterable.this.firstRequest);
            }
            return ListRecoveryGroupsIterable.this.client.listRecoveryGroups((ListRecoveryGroupsRequest)((Object)ListRecoveryGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

