/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessClient;
import software.amazon.awssdk.services.route53recoveryreadiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListResourceSetsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListResourceSetsResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ResourceSetOutput;

public class ListResourceSetsIterable
implements SdkIterable<ListResourceSetsResponse> {
    private final Route53RecoveryReadinessClient client;
    private final ListResourceSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceSetsIterable(Route53RecoveryReadinessClient client, ListResourceSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceSetsResponseFetcher();
    }

    public Iterator<ListResourceSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceSetOutput> resourceSets() {
        Function<ListResourceSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceSets() != null) {
                return response.resourceSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceSetsResponseFetcher
    implements SyncPageFetcher<ListResourceSetsResponse> {
        private ListResourceSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceSetsResponse nextPage(ListResourceSetsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceSetsIterable.this.client.listResourceSets(ListResourceSetsIterable.this.firstRequest);
            }
            return ListResourceSetsIterable.this.client.listResourceSets((ListResourceSetsRequest)((Object)ListResourceSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

