/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessClient;
import software.amazon.awssdk.services.route53recoveryreadiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.GetRecoveryGroupReadinessSummaryResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ReadinessCheckSummary;

public class GetRecoveryGroupReadinessSummaryIterable
implements SdkIterable<GetRecoveryGroupReadinessSummaryResponse> {
    private final Route53RecoveryReadinessClient client;
    private final GetRecoveryGroupReadinessSummaryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetRecoveryGroupReadinessSummaryIterable(Route53RecoveryReadinessClient client, GetRecoveryGroupReadinessSummaryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetRecoveryGroupReadinessSummaryResponseFetcher();
    }

    public Iterator<GetRecoveryGroupReadinessSummaryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReadinessCheckSummary> readinessChecks() {
        Function<GetRecoveryGroupReadinessSummaryResponse, Iterator> getIterator = response -> {
            if (response != null && response.readinessChecks() != null) {
                return response.readinessChecks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetRecoveryGroupReadinessSummaryResponseFetcher
    implements SyncPageFetcher<GetRecoveryGroupReadinessSummaryResponse> {
        private GetRecoveryGroupReadinessSummaryResponseFetcher() {
        }

        public boolean hasNextPage(GetRecoveryGroupReadinessSummaryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetRecoveryGroupReadinessSummaryResponse nextPage(GetRecoveryGroupReadinessSummaryResponse previousPage) {
            if (previousPage == null) {
                return GetRecoveryGroupReadinessSummaryIterable.this.client.getRecoveryGroupReadinessSummary(GetRecoveryGroupReadinessSummaryIterable.this.firstRequest);
            }
            return GetRecoveryGroupReadinessSummaryIterable.this.client.getRecoveryGroupReadinessSummary((GetRecoveryGroupReadinessSummaryRequest)((Object)GetRecoveryGroupReadinessSummaryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

