/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.AutodefinedReverseFlag;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResolverConfigRequest
extends Route53ResolverRequest
implements ToCopyableBuilder<Builder, UpdateResolverConfigRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(UpdateResolverConfigRequest.getter(UpdateResolverConfigRequest::resourceId)).setter(UpdateResolverConfigRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> AUTODEFINED_REVERSE_FLAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutodefinedReverseFlag").getter(UpdateResolverConfigRequest.getter(UpdateResolverConfigRequest::autodefinedReverseFlagAsString)).setter(UpdateResolverConfigRequest.setter(Builder::autodefinedReverseFlag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutodefinedReverseFlag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, AUTODEFINED_REVERSE_FLAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateResolverConfigRequest.memberNameToFieldInitializer();
    private final String resourceId;
    private final String autodefinedReverseFlag;

    private UpdateResolverConfigRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.autodefinedReverseFlag = builder.autodefinedReverseFlag;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final AutodefinedReverseFlag autodefinedReverseFlag() {
        return AutodefinedReverseFlag.fromValue(this.autodefinedReverseFlag);
    }

    public final String autodefinedReverseFlagAsString() {
        return this.autodefinedReverseFlag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autodefinedReverseFlagAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResolverConfigRequest)) {
            return false;
        }
        UpdateResolverConfigRequest other = (UpdateResolverConfigRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.autodefinedReverseFlagAsString(), other.autodefinedReverseFlagAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResolverConfigRequest").add("ResourceId", (Object)this.resourceId()).add("AutodefinedReverseFlag", (Object)this.autodefinedReverseFlagAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "AutodefinedReverseFlag": {
                return Optional.ofNullable(clazz.cast(this.autodefinedReverseFlagAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("AutodefinedReverseFlag", AUTODEFINED_REVERSE_FLAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResolverConfigRequest, T> g) {
        return obj -> g.apply((UpdateResolverConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverRequest.BuilderImpl
    implements Builder {
        private String resourceId;
        private String autodefinedReverseFlag;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResolverConfigRequest model) {
            super(model);
            this.resourceId(model.resourceId);
            this.autodefinedReverseFlag(model.autodefinedReverseFlag);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getAutodefinedReverseFlag() {
            return this.autodefinedReverseFlag;
        }

        public final void setAutodefinedReverseFlag(String autodefinedReverseFlag) {
            this.autodefinedReverseFlag = autodefinedReverseFlag;
        }

        @Override
        public final Builder autodefinedReverseFlag(String autodefinedReverseFlag) {
            this.autodefinedReverseFlag = autodefinedReverseFlag;
            return this;
        }

        @Override
        public final Builder autodefinedReverseFlag(AutodefinedReverseFlag autodefinedReverseFlag) {
            this.autodefinedReverseFlag(autodefinedReverseFlag == null ? null : autodefinedReverseFlag.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResolverConfigRequest build() {
            return new UpdateResolverConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53ResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResolverConfigRequest> {
        public Builder resourceId(String var1);

        public Builder autodefinedReverseFlag(String var1);

        public Builder autodefinedReverseFlag(AutodefinedReverseFlag var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

