/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverAsyncClient;
import software.amazon.awssdk.services.route53resolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversRequest;
import software.amazon.awssdk.services.route53resolver.model.ListOutpostResolversResponse;
import software.amazon.awssdk.services.route53resolver.model.OutpostResolver;

public class ListOutpostResolversPublisher
implements SdkPublisher<ListOutpostResolversResponse> {
    private final Route53ResolverAsyncClient client;
    private final ListOutpostResolversRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOutpostResolversPublisher(Route53ResolverAsyncClient client, ListOutpostResolversRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOutpostResolversPublisher(Route53ResolverAsyncClient client, ListOutpostResolversRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOutpostResolversResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOutpostResolversResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OutpostResolver> outpostResolvers() {
        Function<ListOutpostResolversResponse, Iterator> getIterator = response -> {
            if (response != null && response.outpostResolvers() != null) {
                return response.outpostResolvers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOutpostResolversResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOutpostResolversResponseFetcher
    implements AsyncPageFetcher<ListOutpostResolversResponse> {
        private ListOutpostResolversResponseFetcher() {
        }

        public boolean hasNextPage(ListOutpostResolversResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOutpostResolversResponse> nextPage(ListOutpostResolversResponse previousPage) {
            if (previousPage == null) {
                return ListOutpostResolversPublisher.this.client.listOutpostResolvers(ListOutpostResolversPublisher.this.firstRequest);
            }
            return ListOutpostResolversPublisher.this.client.listOutpostResolvers((ListOutpostResolversRequest)((Object)ListOutpostResolversPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

