/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the information about whether the app monitor stores copies of the data that RUM collects
 * in CloudWatch Logs. If it does, this structure also contains the name of the log group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CwLog implements SdkPojo, Serializable, ToCopyableBuilder<CwLog.Builder, CwLog> {
    private static final SdkField<Boolean> CW_LOG_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CwLogEnabled").getter(getter(CwLog::cwLogEnabled)).setter(setter(Builder::cwLogEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CwLogEnabled").build()).build();

    private static final SdkField<String> CW_LOG_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CwLogGroup").getter(getter(CwLog::cwLogGroup)).setter(setter(Builder::cwLogGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CwLogGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CW_LOG_ENABLED_FIELD,
            CW_LOG_GROUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean cwLogEnabled;

    private final String cwLogGroup;

    private CwLog(BuilderImpl builder) {
        this.cwLogEnabled = builder.cwLogEnabled;
        this.cwLogGroup = builder.cwLogGroup;
    }

    /**
     * <p>
     * Indicated whether the app monitor stores copies of the data that RUM collects in CloudWatch Logs.
     * </p>
     * 
     * @return Indicated whether the app monitor stores copies of the data that RUM collects in CloudWatch Logs.
     */
    public final Boolean cwLogEnabled() {
        return cwLogEnabled;
    }

    /**
     * <p>
     * The name of the log group where the copies are stored.
     * </p>
     * 
     * @return The name of the log group where the copies are stored.
     */
    public final String cwLogGroup() {
        return cwLogGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cwLogEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cwLogGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CwLog)) {
            return false;
        }
        CwLog other = (CwLog) obj;
        return Objects.equals(cwLogEnabled(), other.cwLogEnabled()) && Objects.equals(cwLogGroup(), other.cwLogGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CwLog").add("CwLogEnabled", cwLogEnabled()).add("CwLogGroup", cwLogGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CwLogEnabled":
            return Optional.ofNullable(clazz.cast(cwLogEnabled()));
        case "CwLogGroup":
            return Optional.ofNullable(clazz.cast(cwLogGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CwLog, T> g) {
        return obj -> g.apply((CwLog) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CwLog> {
        /**
         * <p>
         * Indicated whether the app monitor stores copies of the data that RUM collects in CloudWatch Logs.
         * </p>
         * 
         * @param cwLogEnabled
         *        Indicated whether the app monitor stores copies of the data that RUM collects in CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cwLogEnabled(Boolean cwLogEnabled);

        /**
         * <p>
         * The name of the log group where the copies are stored.
         * </p>
         * 
         * @param cwLogGroup
         *        The name of the log group where the copies are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cwLogGroup(String cwLogGroup);
    }

    static final class BuilderImpl implements Builder {
        private Boolean cwLogEnabled;

        private String cwLogGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CwLog model) {
            cwLogEnabled(model.cwLogEnabled);
            cwLogGroup(model.cwLogGroup);
        }

        public final Boolean getCwLogEnabled() {
            return cwLogEnabled;
        }

        public final void setCwLogEnabled(Boolean cwLogEnabled) {
            this.cwLogEnabled = cwLogEnabled;
        }

        @Override
        @Transient
        public final Builder cwLogEnabled(Boolean cwLogEnabled) {
            this.cwLogEnabled = cwLogEnabled;
            return this;
        }

        public final String getCwLogGroup() {
            return cwLogGroup;
        }

        public final void setCwLogGroup(String cwLogGroup) {
            this.cwLogGroup = cwLogGroup;
        }

        @Override
        @Transient
        public final Builder cwLogGroup(String cwLogGroup) {
            this.cwLogGroup = cwLogGroup;
            return this;
        }

        @Override
        public CwLog build() {
            return new CwLog(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
