/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rum.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about whether this app monitor stores a copy of the telemetry data that RUM
 * collects using CloudWatch Logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataStorage implements SdkPojo, Serializable, ToCopyableBuilder<DataStorage.Builder, DataStorage> {
    private static final SdkField<CwLog> CW_LOG_FIELD = SdkField.<CwLog> builder(MarshallingType.SDK_POJO).memberName("CwLog")
            .getter(getter(DataStorage::cwLog)).setter(setter(Builder::cwLog)).constructor(CwLog::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CwLog").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CW_LOG_FIELD));

    private static final long serialVersionUID = 1L;

    private final CwLog cwLog;

    private DataStorage(BuilderImpl builder) {
        this.cwLog = builder.cwLog;
    }

    /**
     * <p>
     * A structure that contains the information about whether the app monitor stores copies of the data that RUM
     * collects in CloudWatch Logs. If it does, this structure also contains the name of the log group.
     * </p>
     * 
     * @return A structure that contains the information about whether the app monitor stores copies of the data that
     *         RUM collects in CloudWatch Logs. If it does, this structure also contains the name of the log group.
     */
    public final CwLog cwLog() {
        return cwLog;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cwLog());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataStorage)) {
            return false;
        }
        DataStorage other = (DataStorage) obj;
        return Objects.equals(cwLog(), other.cwLog());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataStorage").add("CwLog", cwLog()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CwLog":
            return Optional.ofNullable(clazz.cast(cwLog()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataStorage, T> g) {
        return obj -> g.apply((DataStorage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataStorage> {
        /**
         * <p>
         * A structure that contains the information about whether the app monitor stores copies of the data that RUM
         * collects in CloudWatch Logs. If it does, this structure also contains the name of the log group.
         * </p>
         * 
         * @param cwLog
         *        A structure that contains the information about whether the app monitor stores copies of the data that
         *        RUM collects in CloudWatch Logs. If it does, this structure also contains the name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cwLog(CwLog cwLog);

        /**
         * <p>
         * A structure that contains the information about whether the app monitor stores copies of the data that RUM
         * collects in CloudWatch Logs. If it does, this structure also contains the name of the log group.
         * </p>
         * This is a convenience that creates an instance of the {@link CwLog.Builder} avoiding the need to create one
         * manually via {@link CwLog#builder()}.
         *
         * When the {@link Consumer} completes, {@link CwLog.Builder#build()} is called immediately and its result is
         * passed to {@link #cwLog(CwLog)}.
         * 
         * @param cwLog
         *        a consumer that will call methods on {@link CwLog.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cwLog(CwLog)
         */
        default Builder cwLog(Consumer<CwLog.Builder> cwLog) {
            return cwLog(CwLog.builder().applyMutation(cwLog).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CwLog cwLog;

        private BuilderImpl() {
        }

        private BuilderImpl(DataStorage model) {
            cwLog(model.cwLog);
        }

        public final CwLog.Builder getCwLog() {
            return cwLog != null ? cwLog.toBuilder() : null;
        }

        public final void setCwLog(CwLog.BuilderImpl cwLog) {
            this.cwLog = cwLog != null ? cwLog.build() : null;
        }

        @Override
        @Transient
        public final Builder cwLog(CwLog cwLog) {
            this.cwLog = cwLog;
            return this;
        }

        @Override
        public DataStorage build() {
            return new DataStorage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
