/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rum.model.AppMonitorConfiguration;
import software.amazon.awssdk.services.rum.model.AppMonitorDomainListCopier;
import software.amazon.awssdk.services.rum.model.AppMonitorPlatform;
import software.amazon.awssdk.services.rum.model.CustomEvents;
import software.amazon.awssdk.services.rum.model.DataStorage;
import software.amazon.awssdk.services.rum.model.DeobfuscationConfiguration;
import software.amazon.awssdk.services.rum.model.StateEnum;
import software.amazon.awssdk.services.rum.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppMonitor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppMonitor> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AppMonitor.getter(AppMonitor::name)).setter(AppMonitor.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(AppMonitor.getter(AppMonitor::domain)).setter(AppMonitor.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<List<String>> DOMAIN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainList").getter(AppMonitor.getter(AppMonitor::domainList)).setter(AppMonitor.setter(Builder::domainList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(AppMonitor.getter(AppMonitor::id)).setter(AppMonitor.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Created").getter(AppMonitor.getter(AppMonitor::created)).setter(AppMonitor.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModified").getter(AppMonitor.getter(AppMonitor::lastModified)).setter(AppMonitor.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(AppMonitor.getter(AppMonitor::tags)).setter(AppMonitor.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(AppMonitor.getter(AppMonitor::stateAsString)).setter(AppMonitor.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<AppMonitorConfiguration> APP_MONITOR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AppMonitorConfiguration").getter(AppMonitor.getter(AppMonitor::appMonitorConfiguration)).setter(AppMonitor.setter(Builder::appMonitorConfiguration)).constructor(AppMonitorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppMonitorConfiguration").build()}).build();
    private static final SdkField<DataStorage> DATA_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataStorage").getter(AppMonitor.getter(AppMonitor::dataStorage)).setter(AppMonitor.setter(Builder::dataStorage)).constructor(DataStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStorage").build()}).build();
    private static final SdkField<CustomEvents> CUSTOM_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomEvents").getter(AppMonitor.getter(AppMonitor::customEvents)).setter(AppMonitor.setter(Builder::customEvents)).constructor(CustomEvents::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEvents").build()}).build();
    private static final SdkField<DeobfuscationConfiguration> DEOBFUSCATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeobfuscationConfiguration").getter(AppMonitor.getter(AppMonitor::deobfuscationConfiguration)).setter(AppMonitor.setter(Builder::deobfuscationConfiguration)).constructor(DeobfuscationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeobfuscationConfiguration").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(AppMonitor.getter(AppMonitor::platformAsString)).setter(AppMonitor.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DOMAIN_FIELD, DOMAIN_LIST_FIELD, ID_FIELD, CREATED_FIELD, LAST_MODIFIED_FIELD, TAGS_FIELD, STATE_FIELD, APP_MONITOR_CONFIGURATION_FIELD, DATA_STORAGE_FIELD, CUSTOM_EVENTS_FIELD, DEOBFUSCATION_CONFIGURATION_FIELD, PLATFORM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AppMonitor.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String domain;
    private final List<String> domainList;
    private final String id;
    private final String created;
    private final String lastModified;
    private final Map<String, String> tags;
    private final String state;
    private final AppMonitorConfiguration appMonitorConfiguration;
    private final DataStorage dataStorage;
    private final CustomEvents customEvents;
    private final DeobfuscationConfiguration deobfuscationConfiguration;
    private final String platform;

    private AppMonitor(BuilderImpl builder) {
        this.name = builder.name;
        this.domain = builder.domain;
        this.domainList = builder.domainList;
        this.id = builder.id;
        this.created = builder.created;
        this.lastModified = builder.lastModified;
        this.tags = builder.tags;
        this.state = builder.state;
        this.appMonitorConfiguration = builder.appMonitorConfiguration;
        this.dataStorage = builder.dataStorage;
        this.customEvents = builder.customEvents;
        this.deobfuscationConfiguration = builder.deobfuscationConfiguration;
        this.platform = builder.platform;
    }

    public final String name() {
        return this.name;
    }

    public final String domain() {
        return this.domain;
    }

    public final boolean hasDomainList() {
        return this.domainList != null && !(this.domainList instanceof SdkAutoConstructList);
    }

    public final List<String> domainList() {
        return this.domainList;
    }

    public final String id() {
        return this.id;
    }

    public final String created() {
        return this.created;
    }

    public final String lastModified() {
        return this.lastModified;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final StateEnum state() {
        return StateEnum.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final AppMonitorConfiguration appMonitorConfiguration() {
        return this.appMonitorConfiguration;
    }

    public final DataStorage dataStorage() {
        return this.dataStorage;
    }

    public final CustomEvents customEvents() {
        return this.customEvents;
    }

    public final DeobfuscationConfiguration deobfuscationConfiguration() {
        return this.deobfuscationConfiguration;
    }

    public final AppMonitorPlatform platform() {
        return AppMonitorPlatform.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainList() ? this.domainList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.appMonitorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.customEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.deobfuscationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppMonitor)) {
            return false;
        }
        AppMonitor other = (AppMonitor)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.domain(), other.domain()) && this.hasDomainList() == other.hasDomainList() && Objects.equals(this.domainList(), other.domainList()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.lastModified(), other.lastModified()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.appMonitorConfiguration(), other.appMonitorConfiguration()) && Objects.equals(this.dataStorage(), other.dataStorage()) && Objects.equals(this.customEvents(), other.customEvents()) && Objects.equals(this.deobfuscationConfiguration(), other.deobfuscationConfiguration()) && Objects.equals(this.platformAsString(), other.platformAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AppMonitor").add("Name", (Object)this.name()).add("Domain", (Object)this.domain()).add("DomainList", this.hasDomainList() ? this.domainList() : null).add("Id", (Object)this.id()).add("Created", (Object)this.created()).add("LastModified", (Object)this.lastModified()).add("Tags", this.hasTags() ? this.tags() : null).add("State", (Object)this.stateAsString()).add("AppMonitorConfiguration", (Object)this.appMonitorConfiguration()).add("DataStorage", (Object)this.dataStorage()).add("CustomEvents", (Object)this.customEvents()).add("DeobfuscationConfiguration", (Object)this.deobfuscationConfiguration()).add("Platform", (Object)this.platformAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "DomainList": {
                return Optional.ofNullable(clazz.cast(this.domainList()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "AppMonitorConfiguration": {
                return Optional.ofNullable(clazz.cast(this.appMonitorConfiguration()));
            }
            case "DataStorage": {
                return Optional.ofNullable(clazz.cast(this.dataStorage()));
            }
            case "CustomEvents": {
                return Optional.ofNullable(clazz.cast(this.customEvents()));
            }
            case "DeobfuscationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deobfuscationConfiguration()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("DomainList", DOMAIN_LIST_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Created", CREATED_FIELD);
        map.put("LastModified", LAST_MODIFIED_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("State", STATE_FIELD);
        map.put("AppMonitorConfiguration", APP_MONITOR_CONFIGURATION_FIELD);
        map.put("DataStorage", DATA_STORAGE_FIELD);
        map.put("CustomEvents", CUSTOM_EVENTS_FIELD);
        map.put("DeobfuscationConfiguration", DEOBFUSCATION_CONFIGURATION_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppMonitor, T> g) {
        return obj -> g.apply((AppMonitor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String domain;
        private List<String> domainList = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private String created;
        private String lastModified;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String state;
        private AppMonitorConfiguration appMonitorConfiguration;
        private DataStorage dataStorage;
        private CustomEvents customEvents;
        private DeobfuscationConfiguration deobfuscationConfiguration;
        private String platform;

        private BuilderImpl() {
        }

        private BuilderImpl(AppMonitor model) {
            this.name(model.name);
            this.domain(model.domain);
            this.domainList(model.domainList);
            this.id(model.id);
            this.created(model.created);
            this.lastModified(model.lastModified);
            this.tags(model.tags);
            this.state(model.state);
            this.appMonitorConfiguration(model.appMonitorConfiguration);
            this.dataStorage(model.dataStorage);
            this.customEvents(model.customEvents);
            this.deobfuscationConfiguration(model.deobfuscationConfiguration);
            this.platform(model.platform);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final Collection<String> getDomainList() {
            if (this.domainList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.domainList;
        }

        public final void setDomainList(Collection<String> domainList) {
            this.domainList = AppMonitorDomainListCopier.copy(domainList);
        }

        @Override
        public final Builder domainList(Collection<String> domainList) {
            this.domainList = AppMonitorDomainListCopier.copy(domainList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainList(String ... domainList) {
            this.domainList(Arrays.asList(domainList));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getCreated() {
            return this.created;
        }

        public final void setCreated(String created) {
            this.created = created;
        }

        @Override
        public final Builder created(String created) {
            this.created = created;
            return this;
        }

        public final String getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StateEnum state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final AppMonitorConfiguration.Builder getAppMonitorConfiguration() {
            return this.appMonitorConfiguration != null ? this.appMonitorConfiguration.toBuilder() : null;
        }

        public final void setAppMonitorConfiguration(AppMonitorConfiguration.BuilderImpl appMonitorConfiguration) {
            this.appMonitorConfiguration = appMonitorConfiguration != null ? appMonitorConfiguration.build() : null;
        }

        @Override
        public final Builder appMonitorConfiguration(AppMonitorConfiguration appMonitorConfiguration) {
            this.appMonitorConfiguration = appMonitorConfiguration;
            return this;
        }

        public final DataStorage.Builder getDataStorage() {
            return this.dataStorage != null ? this.dataStorage.toBuilder() : null;
        }

        public final void setDataStorage(DataStorage.BuilderImpl dataStorage) {
            this.dataStorage = dataStorage != null ? dataStorage.build() : null;
        }

        @Override
        public final Builder dataStorage(DataStorage dataStorage) {
            this.dataStorage = dataStorage;
            return this;
        }

        public final CustomEvents.Builder getCustomEvents() {
            return this.customEvents != null ? this.customEvents.toBuilder() : null;
        }

        public final void setCustomEvents(CustomEvents.BuilderImpl customEvents) {
            this.customEvents = customEvents != null ? customEvents.build() : null;
        }

        @Override
        public final Builder customEvents(CustomEvents customEvents) {
            this.customEvents = customEvents;
            return this;
        }

        public final DeobfuscationConfiguration.Builder getDeobfuscationConfiguration() {
            return this.deobfuscationConfiguration != null ? this.deobfuscationConfiguration.toBuilder() : null;
        }

        public final void setDeobfuscationConfiguration(DeobfuscationConfiguration.BuilderImpl deobfuscationConfiguration) {
            this.deobfuscationConfiguration = deobfuscationConfiguration != null ? deobfuscationConfiguration.build() : null;
        }

        @Override
        public final Builder deobfuscationConfiguration(DeobfuscationConfiguration deobfuscationConfiguration) {
            this.deobfuscationConfiguration = deobfuscationConfiguration;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(AppMonitorPlatform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public AppMonitor build() {
            return new AppMonitor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppMonitor> {
        public Builder name(String var1);

        public Builder domain(String var1);

        public Builder domainList(Collection<String> var1);

        public Builder domainList(String ... var1);

        public Builder id(String var1);

        public Builder created(String var1);

        public Builder lastModified(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder state(String var1);

        public Builder state(StateEnum var1);

        public Builder appMonitorConfiguration(AppMonitorConfiguration var1);

        default public Builder appMonitorConfiguration(Consumer<AppMonitorConfiguration.Builder> appMonitorConfiguration) {
            return this.appMonitorConfiguration((AppMonitorConfiguration)((AppMonitorConfiguration.Builder)AppMonitorConfiguration.builder().applyMutation(appMonitorConfiguration)).build());
        }

        public Builder dataStorage(DataStorage var1);

        default public Builder dataStorage(Consumer<DataStorage.Builder> dataStorage) {
            return this.dataStorage((DataStorage)((DataStorage.Builder)DataStorage.builder().applyMutation(dataStorage)).build());
        }

        public Builder customEvents(CustomEvents var1);

        default public Builder customEvents(Consumer<CustomEvents.Builder> customEvents) {
            return this.customEvents((CustomEvents)((CustomEvents.Builder)CustomEvents.builder().applyMutation(customEvents)).build());
        }

        public Builder deobfuscationConfiguration(DeobfuscationConfiguration var1);

        default public Builder deobfuscationConfiguration(Consumer<DeobfuscationConfiguration.Builder> deobfuscationConfiguration) {
            return this.deobfuscationConfiguration((DeobfuscationConfiguration)((DeobfuscationConfiguration.Builder)DeobfuscationConfiguration.builder().applyMutation(deobfuscationConfiguration)).build());
        }

        public Builder platform(String var1);

        public Builder platform(AppMonitorPlatform var1);
    }
}

