/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AppMonitorPlatform {
    WEB("Web"),
    ANDROID("Android"),
    I_OS("iOS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AppMonitorPlatform> VALUE_MAP;
    private final String value;

    private AppMonitorPlatform(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AppMonitorPlatform fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AppMonitorPlatform> knownValues() {
        EnumSet<AppMonitorPlatform> knownValues = EnumSet.allOf(AppMonitorPlatform.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AppMonitorPlatform.class, AppMonitorPlatform::toString);
    }
}

