/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rum.model.MetricDefinitionRequest;
import software.amazon.awssdk.services.rum.model.MetricDestination;
import software.amazon.awssdk.services.rum.model.RumRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRumMetricDefinitionRequest
extends RumRequest
implements ToCopyableBuilder<Builder, UpdateRumMetricDefinitionRequest> {
    private static final SdkField<String> APP_MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppMonitorName").getter(UpdateRumMetricDefinitionRequest.getter(UpdateRumMetricDefinitionRequest::appMonitorName)).setter(UpdateRumMetricDefinitionRequest.setter(Builder::appMonitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AppMonitorName").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(UpdateRumMetricDefinitionRequest.getter(UpdateRumMetricDefinitionRequest::destinationAsString)).setter(UpdateRumMetricDefinitionRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationArn").getter(UpdateRumMetricDefinitionRequest.getter(UpdateRumMetricDefinitionRequest::destinationArn)).setter(UpdateRumMetricDefinitionRequest.setter(Builder::destinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationArn").build()}).build();
    private static final SdkField<MetricDefinitionRequest> METRIC_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricDefinition").getter(UpdateRumMetricDefinitionRequest.getter(UpdateRumMetricDefinitionRequest::metricDefinition)).setter(UpdateRumMetricDefinitionRequest.setter(Builder::metricDefinition)).constructor(MetricDefinitionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDefinition").build()}).build();
    private static final SdkField<String> METRIC_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricDefinitionId").getter(UpdateRumMetricDefinitionRequest.getter(UpdateRumMetricDefinitionRequest::metricDefinitionId)).setter(UpdateRumMetricDefinitionRequest.setter(Builder::metricDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDefinitionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_MONITOR_NAME_FIELD, DESTINATION_FIELD, DESTINATION_ARN_FIELD, METRIC_DEFINITION_FIELD, METRIC_DEFINITION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateRumMetricDefinitionRequest.memberNameToFieldInitializer();
    private final String appMonitorName;
    private final String destination;
    private final String destinationArn;
    private final MetricDefinitionRequest metricDefinition;
    private final String metricDefinitionId;

    private UpdateRumMetricDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.appMonitorName = builder.appMonitorName;
        this.destination = builder.destination;
        this.destinationArn = builder.destinationArn;
        this.metricDefinition = builder.metricDefinition;
        this.metricDefinitionId = builder.metricDefinitionId;
    }

    public final String appMonitorName() {
        return this.appMonitorName;
    }

    public final MetricDestination destination() {
        return MetricDestination.fromValue(this.destination);
    }

    public final String destinationAsString() {
        return this.destination;
    }

    public final String destinationArn() {
        return this.destinationArn;
    }

    public final MetricDefinitionRequest metricDefinition() {
        return this.metricDefinition;
    }

    public final String metricDefinitionId() {
        return this.metricDefinitionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appMonitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricDefinitionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRumMetricDefinitionRequest)) {
            return false;
        }
        UpdateRumMetricDefinitionRequest other = (UpdateRumMetricDefinitionRequest)((Object)obj);
        return Objects.equals(this.appMonitorName(), other.appMonitorName()) && Objects.equals(this.destinationAsString(), other.destinationAsString()) && Objects.equals(this.destinationArn(), other.destinationArn()) && Objects.equals(this.metricDefinition(), other.metricDefinition()) && Objects.equals(this.metricDefinitionId(), other.metricDefinitionId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRumMetricDefinitionRequest").add("AppMonitorName", (Object)this.appMonitorName()).add("Destination", (Object)this.destinationAsString()).add("DestinationArn", (Object)this.destinationArn()).add("MetricDefinition", (Object)this.metricDefinition()).add("MetricDefinitionId", (Object)this.metricDefinitionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppMonitorName": {
                return Optional.ofNullable(clazz.cast(this.appMonitorName()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destinationAsString()));
            }
            case "DestinationArn": {
                return Optional.ofNullable(clazz.cast(this.destinationArn()));
            }
            case "MetricDefinition": {
                return Optional.ofNullable(clazz.cast(this.metricDefinition()));
            }
            case "MetricDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.metricDefinitionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AppMonitorName", APP_MONITOR_NAME_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("DestinationArn", DESTINATION_ARN_FIELD);
        map.put("MetricDefinition", METRIC_DEFINITION_FIELD);
        map.put("MetricDefinitionId", METRIC_DEFINITION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRumMetricDefinitionRequest, T> g) {
        return obj -> g.apply((UpdateRumMetricDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RumRequest.BuilderImpl
    implements Builder {
        private String appMonitorName;
        private String destination;
        private String destinationArn;
        private MetricDefinitionRequest metricDefinition;
        private String metricDefinitionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRumMetricDefinitionRequest model) {
            super(model);
            this.appMonitorName(model.appMonitorName);
            this.destination(model.destination);
            this.destinationArn(model.destinationArn);
            this.metricDefinition(model.metricDefinition);
            this.metricDefinitionId(model.metricDefinitionId);
        }

        public final String getAppMonitorName() {
            return this.appMonitorName;
        }

        public final void setAppMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
        }

        @Override
        public final Builder appMonitorName(String appMonitorName) {
            this.appMonitorName = appMonitorName;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder destination(MetricDestination destination) {
            this.destination(destination == null ? null : destination.toString());
            return this;
        }

        public final String getDestinationArn() {
            return this.destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final MetricDefinitionRequest.Builder getMetricDefinition() {
            return this.metricDefinition != null ? this.metricDefinition.toBuilder() : null;
        }

        public final void setMetricDefinition(MetricDefinitionRequest.BuilderImpl metricDefinition) {
            this.metricDefinition = metricDefinition != null ? metricDefinition.build() : null;
        }

        @Override
        public final Builder metricDefinition(MetricDefinitionRequest metricDefinition) {
            this.metricDefinition = metricDefinition;
            return this;
        }

        public final String getMetricDefinitionId() {
            return this.metricDefinitionId;
        }

        public final void setMetricDefinitionId(String metricDefinitionId) {
            this.metricDefinitionId = metricDefinitionId;
        }

        @Override
        public final Builder metricDefinitionId(String metricDefinitionId) {
            this.metricDefinitionId = metricDefinitionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRumMetricDefinitionRequest build() {
            return new UpdateRumMetricDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RumRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRumMetricDefinitionRequest> {
        public Builder appMonitorName(String var1);

        public Builder destination(String var1);

        public Builder destination(MetricDestination var1);

        public Builder destinationArn(String var1);

        public Builder metricDefinition(MetricDefinitionRequest var1);

        default public Builder metricDefinition(Consumer<MetricDefinitionRequest.Builder> metricDefinition) {
            return this.metricDefinition((MetricDefinitionRequest)((MetricDefinitionRequest.Builder)MetricDefinitionRequest.builder().applyMutation(metricDefinition)).build());
        }

        public Builder metricDefinitionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

