/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InventoryFrequency {
    DAILY("Daily"),
    WEEKLY("Weekly"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InventoryFrequency> VALUE_MAP;
    private final String value;

    private InventoryFrequency(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InventoryFrequency fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InventoryFrequency> knownValues() {
        EnumSet<InventoryFrequency> knownValues = EnumSet.allOf(InventoryFrequency.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InventoryFrequency.class, InventoryFrequency::toString);
    }
}

