/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.crossregion.endpointprovider;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.endpoints.S3EndpointParams;
import software.amazon.awssdk.services.s3.endpoints.S3EndpointProvider;

@SdkInternalApi
public class BucketEndpointProvider
implements S3EndpointProvider {
    private final S3EndpointProvider delegateEndPointProvider;
    private final Supplier<Region> regionSupplier;

    private BucketEndpointProvider(S3EndpointProvider delegateEndPointProvider, Supplier<Region> regionSupplier) {
        this.delegateEndPointProvider = delegateEndPointProvider;
        this.regionSupplier = regionSupplier;
    }

    public static BucketEndpointProvider create(S3EndpointProvider delegateEndPointProvider, Supplier<Region> regionSupplier) {
        return new BucketEndpointProvider(delegateEndPointProvider, regionSupplier);
    }

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(S3EndpointParams endpointParams) {
        Region crossRegion = this.regionSupplier.get();
        S3EndpointParams.Builder endpointParamsBuilder = endpointParams.toBuilder();
        if (crossRegion != null) {
            endpointParamsBuilder.region(crossRegion);
        } else {
            if (Region.AWS_GLOBAL.equals(endpointParams.region())) {
                endpointParamsBuilder.region(Region.US_EAST_1);
            }
            endpointParamsBuilder.useGlobalEndpoint(false);
        }
        return this.delegateEndPointProvider.resolveEndpoint(endpointParamsBuilder.build());
    }
}

