/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.multipart;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.DelegatingS3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3.internal.multipart.CopyObjectHelper;
import software.amazon.awssdk.services.s3.internal.multipart.DownloadObjectHelper;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartConfigurationResolver;
import software.amazon.awssdk.services.s3.internal.multipart.S3ChecksumUtils;
import software.amazon.awssdk.services.s3.internal.multipart.UploadObjectHelper;
import software.amazon.awssdk.services.s3.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.services.s3.multipart.MultipartConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class MultipartS3AsyncClient
extends DelegatingS3AsyncClient {
    private static final ApiName USER_AGENT_API_NAME = ApiName.builder().name("hll").version("s3Multipart").build();
    private final UploadObjectHelper mpuHelper;
    private final CopyObjectHelper copyObjectHelper;
    private final DownloadObjectHelper downloadObjectHelper;
    private final boolean checksumEnabled;

    private MultipartS3AsyncClient(S3AsyncClient delegate, MultipartConfiguration multipartConfiguration, boolean checksumEnabled) {
        super(delegate);
        MultipartConfiguration validConfiguration = (MultipartConfiguration)Validate.getOrDefault((Object)multipartConfiguration, () -> ((MultipartConfiguration.Builder)MultipartConfiguration.builder()).build());
        MultipartConfigurationResolver resolver = new MultipartConfigurationResolver(validConfiguration);
        long minPartSizeInBytes = resolver.minimalPartSizeInBytes();
        long threshold = resolver.thresholdInBytes();
        long apiCallBufferSize = resolver.apiCallBufferSize();
        int maxInFlightParts = resolver.maxInFlightParts();
        this.mpuHelper = new UploadObjectHelper(delegate, resolver);
        this.copyObjectHelper = new CopyObjectHelper(delegate, minPartSizeInBytes, threshold);
        this.downloadObjectHelper = new DownloadObjectHelper(delegate, apiCallBufferSize, maxInFlightParts);
        this.checksumEnabled = checksumEnabled;
    }

    @Override
    public CompletableFuture<PutObjectResponse> putObject(PutObjectRequest putObjectRequest, AsyncRequestBody requestBody) {
        Optional<ChecksumAlgorithm> checksumAlgorithm = S3ChecksumUtils.checksumAlgorithmFromPutObjectRequest(putObjectRequest);
        if (checksumAlgorithm.isPresent()) {
            putObjectRequest = (PutObjectRequest)((Object)putObjectRequest.toBuilder().checksumAlgorithm(checksumAlgorithm.get()).build());
        } else if (this.checksumEnabled) {
            putObjectRequest = (PutObjectRequest)((Object)putObjectRequest.toBuilder().checksumAlgorithm(ChecksumAlgorithm.CRC32).build());
        }
        return this.mpuHelper.uploadObject(putObjectRequest, requestBody);
    }

    @Override
    public CompletableFuture<CopyObjectResponse> copyObject(CopyObjectRequest copyObjectRequest) {
        return this.copyObjectHelper.copyObject(copyObjectRequest);
    }

    @Override
    public <ReturnT> CompletableFuture<ReturnT> getObject(GetObjectRequest getObjectRequest, AsyncResponseTransformer<GetObjectResponse, ReturnT> asyncResponseTransformer) {
        return this.downloadObjectHelper.downloadObject(getObjectRequest, asyncResponseTransformer);
    }

    @Override
    public void close() {
        this.delegate().close();
    }

    public static MultipartS3AsyncClient create(S3AsyncClient client, MultipartConfiguration multipartConfiguration, boolean checksumEnabled) {
        DelegatingS3AsyncClient clientWithUserAgent = new DelegatingS3AsyncClient(client){

            @Override
            protected <T extends S3Request, ReturnT> CompletableFuture<ReturnT> invokeOperation(T request, Function<T, CompletableFuture<ReturnT>> operation) {
                T requestWithUserAgent = UserAgentUtils.applyUserAgentInfo(request, c -> c.addApiName(USER_AGENT_API_NAME));
                return operation.apply(requestWithUserAgent);
            }
        };
        return new MultipartS3AsyncClient(clientWithUserAgent, multipartConfiguration, checksumEnabled);
    }
}

