/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.ComputeObjectChecksumAlgorithm;
import software.amazon.awssdk.services.s3control.model.ComputeObjectChecksumType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ComputeObjectChecksumOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ComputeObjectChecksumOperation> {
    private static final SdkField<String> CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChecksumAlgorithm").getter(S3ComputeObjectChecksumOperation.getter(S3ComputeObjectChecksumOperation::checksumAlgorithmAsString)).setter(S3ComputeObjectChecksumOperation.setter(Builder::checksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChecksumAlgorithm").unmarshallLocationName("ChecksumAlgorithm").build()}).build();
    private static final SdkField<String> CHECKSUM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChecksumType").getter(S3ComputeObjectChecksumOperation.getter(S3ComputeObjectChecksumOperation::checksumTypeAsString)).setter(S3ComputeObjectChecksumOperation.setter(Builder::checksumType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChecksumType").unmarshallLocationName("ChecksumType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECKSUM_ALGORITHM_FIELD, CHECKSUM_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3ComputeObjectChecksumOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String checksumAlgorithm;
    private final String checksumType;

    private S3ComputeObjectChecksumOperation(BuilderImpl builder) {
        this.checksumAlgorithm = builder.checksumAlgorithm;
        this.checksumType = builder.checksumType;
    }

    public final ComputeObjectChecksumAlgorithm checksumAlgorithm() {
        return ComputeObjectChecksumAlgorithm.fromValue(this.checksumAlgorithm);
    }

    public final String checksumAlgorithmAsString() {
        return this.checksumAlgorithm;
    }

    public final ComputeObjectChecksumType checksumType() {
        return ComputeObjectChecksumType.fromValue(this.checksumType);
    }

    public final String checksumTypeAsString() {
        return this.checksumType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.checksumAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksumTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ComputeObjectChecksumOperation)) {
            return false;
        }
        S3ComputeObjectChecksumOperation other = (S3ComputeObjectChecksumOperation)obj;
        return Objects.equals(this.checksumAlgorithmAsString(), other.checksumAlgorithmAsString()) && Objects.equals(this.checksumTypeAsString(), other.checksumTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"S3ComputeObjectChecksumOperation").add("ChecksumAlgorithm", (Object)this.checksumAlgorithmAsString()).add("ChecksumType", (Object)this.checksumTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.checksumAlgorithmAsString()));
            }
            case "ChecksumType": {
                return Optional.ofNullable(clazz.cast(this.checksumTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ChecksumAlgorithm", CHECKSUM_ALGORITHM_FIELD);
        map.put("ChecksumType", CHECKSUM_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ComputeObjectChecksumOperation, T> g) {
        return obj -> g.apply((S3ComputeObjectChecksumOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String checksumAlgorithm;
        private String checksumType;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ComputeObjectChecksumOperation model) {
            this.checksumAlgorithm(model.checksumAlgorithm);
            this.checksumType(model.checksumType);
        }

        public final String getChecksumAlgorithm() {
            return this.checksumAlgorithm;
        }

        public final void setChecksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
        }

        @Override
        public final Builder checksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
            return this;
        }

        @Override
        public final Builder checksumAlgorithm(ComputeObjectChecksumAlgorithm checksumAlgorithm) {
            this.checksumAlgorithm(checksumAlgorithm == null ? null : checksumAlgorithm.toString());
            return this;
        }

        public final String getChecksumType() {
            return this.checksumType;
        }

        public final void setChecksumType(String checksumType) {
            this.checksumType = checksumType;
        }

        @Override
        public final Builder checksumType(String checksumType) {
            this.checksumType = checksumType;
            return this;
        }

        @Override
        public final Builder checksumType(ComputeObjectChecksumType checksumType) {
            this.checksumType(checksumType == null ? null : checksumType.toString());
            return this;
        }

        public S3ComputeObjectChecksumOperation build() {
            return new S3ComputeObjectChecksumOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ComputeObjectChecksumOperation> {
        public Builder checksumAlgorithm(String var1);

        public Builder checksumAlgorithm(ComputeObjectChecksumAlgorithm var1);

        public Builder checksumType(String var1);

        public Builder checksumType(ComputeObjectChecksumType var1);
    }
}

