/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTableMetadataLocationResponse extends S3TablesResponse implements
        ToCopyableBuilder<GetTableMetadataLocationResponse.Builder, GetTableMetadataLocationResponse> {
    private static final SdkField<String> VERSION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionToken").getter(getter(GetTableMetadataLocationResponse::versionToken))
            .setter(setter(Builder::versionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionToken").build()).build();

    private static final SdkField<String> METADATA_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metadataLocation").getter(getter(GetTableMetadataLocationResponse::metadataLocation))
            .setter(setter(Builder::metadataLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataLocation").build()).build();

    private static final SdkField<String> WAREHOUSE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("warehouseLocation").getter(getter(GetTableMetadataLocationResponse::warehouseLocation))
            .setter(setter(Builder::warehouseLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warehouseLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_TOKEN_FIELD,
            METADATA_LOCATION_FIELD, WAREHOUSE_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("versionToken", VERSION_TOKEN_FIELD);
                    put("metadataLocation", METADATA_LOCATION_FIELD);
                    put("warehouseLocation", WAREHOUSE_LOCATION_FIELD);
                }
            });

    private final String versionToken;

    private final String metadataLocation;

    private final String warehouseLocation;

    private GetTableMetadataLocationResponse(BuilderImpl builder) {
        super(builder);
        this.versionToken = builder.versionToken;
        this.metadataLocation = builder.metadataLocation;
        this.warehouseLocation = builder.warehouseLocation;
    }

    /**
     * <p>
     * The version token.
     * </p>
     * 
     * @return The version token.
     */
    public final String versionToken() {
        return versionToken;
    }

    /**
     * <p>
     * The metadata location.
     * </p>
     * 
     * @return The metadata location.
     */
    public final String metadataLocation() {
        return metadataLocation;
    }

    /**
     * <p>
     * The warehouse location.
     * </p>
     * 
     * @return The warehouse location.
     */
    public final String warehouseLocation() {
        return warehouseLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(versionToken());
        hashCode = 31 * hashCode + Objects.hashCode(metadataLocation());
        hashCode = 31 * hashCode + Objects.hashCode(warehouseLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableMetadataLocationResponse)) {
            return false;
        }
        GetTableMetadataLocationResponse other = (GetTableMetadataLocationResponse) obj;
        return Objects.equals(versionToken(), other.versionToken())
                && Objects.equals(metadataLocation(), other.metadataLocation())
                && Objects.equals(warehouseLocation(), other.warehouseLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTableMetadataLocationResponse").add("VersionToken", versionToken())
                .add("MetadataLocation", metadataLocation()).add("WarehouseLocation", warehouseLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "versionToken":
            return Optional.ofNullable(clazz.cast(versionToken()));
        case "metadataLocation":
            return Optional.ofNullable(clazz.cast(metadataLocation()));
        case "warehouseLocation":
            return Optional.ofNullable(clazz.cast(warehouseLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTableMetadataLocationResponse, T> g) {
        return obj -> g.apply((GetTableMetadataLocationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3TablesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTableMetadataLocationResponse> {
        /**
         * <p>
         * The version token.
         * </p>
         * 
         * @param versionToken
         *        The version token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionToken(String versionToken);

        /**
         * <p>
         * The metadata location.
         * </p>
         * 
         * @param metadataLocation
         *        The metadata location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataLocation(String metadataLocation);

        /**
         * <p>
         * The warehouse location.
         * </p>
         * 
         * @param warehouseLocation
         *        The warehouse location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warehouseLocation(String warehouseLocation);
    }

    static final class BuilderImpl extends S3TablesResponse.BuilderImpl implements Builder {
        private String versionToken;

        private String metadataLocation;

        private String warehouseLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableMetadataLocationResponse model) {
            super(model);
            versionToken(model.versionToken);
            metadataLocation(model.metadataLocation);
            warehouseLocation(model.warehouseLocation);
        }

        public final String getVersionToken() {
            return versionToken;
        }

        public final void setVersionToken(String versionToken) {
            this.versionToken = versionToken;
        }

        @Override
        public final Builder versionToken(String versionToken) {
            this.versionToken = versionToken;
            return this;
        }

        public final String getMetadataLocation() {
            return metadataLocation;
        }

        public final void setMetadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
        }

        @Override
        public final Builder metadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
            return this;
        }

        public final String getWarehouseLocation() {
            return warehouseLocation;
        }

        public final void setWarehouseLocation(String warehouseLocation) {
            this.warehouseLocation = warehouseLocation;
        }

        @Override
        public final Builder warehouseLocation(String warehouseLocation) {
            this.warehouseLocation = warehouseLocation;
            return this;
        }

        @Override
        public GetTableMetadataLocationResponse build() {
            return new GetTableMetadataLocationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
