/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTableRequest extends S3TablesRequest implements ToCopyableBuilder<GetTableRequest.Builder, GetTableRequest> {
    private static final SdkField<String> TABLE_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableBucketARN").getter(getter(GetTableRequest::tableBucketARN)).setter(setter(Builder::tableBucketARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableBucketARN").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(GetTableRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("namespace").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetTableRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKET_ARN_FIELD,
            NAMESPACE_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("tableBucketARN", TABLE_BUCKET_ARN_FIELD);
                    put("namespace", NAMESPACE_FIELD);
                    put("name", NAME_FIELD);
                }
            });

    private final String tableBucketARN;

    private final String namespace;

    private final String name;

    private GetTableRequest(BuilderImpl builder) {
        super(builder);
        this.tableBucketARN = builder.tableBucketARN;
        this.namespace = builder.namespace;
        this.name = builder.name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the table bucket associated with the table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the table bucket associated with the table.
     */
    public final String tableBucketARN() {
        return tableBucketARN;
    }

    /**
     * <p>
     * The name of the namespace the table is associated with.
     * </p>
     * 
     * @return The name of the namespace the table is associated with.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableBucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableRequest)) {
            return false;
        }
        GetTableRequest other = (GetTableRequest) obj;
        return Objects.equals(tableBucketARN(), other.tableBucketARN()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTableRequest").add("TableBucketARN", tableBucketARN()).add("Namespace", namespace())
                .add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tableBucketARN":
            return Optional.ofNullable(clazz.cast(tableBucketARN()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTableRequest, T> g) {
        return obj -> g.apply((GetTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3TablesRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTableRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the table bucket associated with the table.
         * </p>
         * 
         * @param tableBucketARN
         *        The Amazon Resource Name (ARN) of the table bucket associated with the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableBucketARN(String tableBucketARN);

        /**
         * <p>
         * The name of the namespace the table is associated with.
         * </p>
         * 
         * @param namespace
         *        The name of the namespace the table is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param name
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3TablesRequest.BuilderImpl implements Builder {
        private String tableBucketARN;

        private String namespace;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableRequest model) {
            super(model);
            tableBucketARN(model.tableBucketARN);
            namespace(model.namespace);
            name(model.name);
        }

        public final String getTableBucketARN() {
            return tableBucketARN;
        }

        public final void setTableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
        }

        @Override
        public final Builder tableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTableRequest build() {
            return new GetTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
