/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutTableBucketMaintenanceConfigurationRequest extends S3TablesRequest implements
        ToCopyableBuilder<PutTableBucketMaintenanceConfigurationRequest.Builder, PutTableBucketMaintenanceConfigurationRequest> {
    private static final SdkField<String> TABLE_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableBucketARN").getter(getter(PutTableBucketMaintenanceConfigurationRequest::tableBucketARN))
            .setter(setter(Builder::tableBucketARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableBucketARN").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(PutTableBucketMaintenanceConfigurationRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("type").build()).build();

    private static final SdkField<TableBucketMaintenanceConfigurationValue> VALUE_FIELD = SdkField
            .<TableBucketMaintenanceConfigurationValue> builder(MarshallingType.SDK_POJO).memberName("value")
            .getter(getter(PutTableBucketMaintenanceConfigurationRequest::value)).setter(setter(Builder::value))
            .constructor(TableBucketMaintenanceConfigurationValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKET_ARN_FIELD,
            TYPE_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("tableBucketARN", TABLE_BUCKET_ARN_FIELD);
                    put("type", TYPE_FIELD);
                    put("value", VALUE_FIELD);
                }
            });

    private final String tableBucketARN;

    private final String type;

    private final TableBucketMaintenanceConfigurationValue value;

    private PutTableBucketMaintenanceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.tableBucketARN = builder.tableBucketARN;
        this.type = builder.type;
        this.value = builder.value;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the table bucket associated with the maintenance configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the table bucket associated with the maintenance configuration.
     */
    public final String tableBucketARN() {
        return tableBucketARN;
    }

    /**
     * <p>
     * The type of the maintenance configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TableBucketMaintenanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the maintenance configuration.
     * @see TableBucketMaintenanceType
     */
    public final TableBucketMaintenanceType type() {
        return TableBucketMaintenanceType.fromValue(type);
    }

    /**
     * <p>
     * The type of the maintenance configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TableBucketMaintenanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the maintenance configuration.
     * @see TableBucketMaintenanceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Defines the values of the maintenance configuration for the table bucket.
     * </p>
     * 
     * @return Defines the values of the maintenance configuration for the table bucket.
     */
    public final TableBucketMaintenanceConfigurationValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableBucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTableBucketMaintenanceConfigurationRequest)) {
            return false;
        }
        PutTableBucketMaintenanceConfigurationRequest other = (PutTableBucketMaintenanceConfigurationRequest) obj;
        return Objects.equals(tableBucketARN(), other.tableBucketARN()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutTableBucketMaintenanceConfigurationRequest").add("TableBucketARN", tableBucketARN())
                .add("Type", typeAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tableBucketARN":
            return Optional.ofNullable(clazz.cast(tableBucketARN()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutTableBucketMaintenanceConfigurationRequest, T> g) {
        return obj -> g.apply((PutTableBucketMaintenanceConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3TablesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutTableBucketMaintenanceConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the table bucket associated with the maintenance configuration.
         * </p>
         * 
         * @param tableBucketARN
         *        The Amazon Resource Name (ARN) of the table bucket associated with the maintenance configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableBucketARN(String tableBucketARN);

        /**
         * <p>
         * The type of the maintenance configuration.
         * </p>
         * 
         * @param type
         *        The type of the maintenance configuration.
         * @see TableBucketMaintenanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableBucketMaintenanceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the maintenance configuration.
         * </p>
         * 
         * @param type
         *        The type of the maintenance configuration.
         * @see TableBucketMaintenanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableBucketMaintenanceType
         */
        Builder type(TableBucketMaintenanceType type);

        /**
         * <p>
         * Defines the values of the maintenance configuration for the table bucket.
         * </p>
         * 
         * @param value
         *        Defines the values of the maintenance configuration for the table bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(TableBucketMaintenanceConfigurationValue value);

        /**
         * <p>
         * Defines the values of the maintenance configuration for the table bucket.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TableBucketMaintenanceConfigurationValue.Builder} avoiding the need to create one manually via
         * {@link TableBucketMaintenanceConfigurationValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableBucketMaintenanceConfigurationValue.Builder#build()} is
         * called immediately and its result is passed to {@link #value(TableBucketMaintenanceConfigurationValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link TableBucketMaintenanceConfigurationValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(TableBucketMaintenanceConfigurationValue)
         */
        default Builder value(Consumer<TableBucketMaintenanceConfigurationValue.Builder> value) {
            return value(TableBucketMaintenanceConfigurationValue.builder().applyMutation(value).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3TablesRequest.BuilderImpl implements Builder {
        private String tableBucketARN;

        private String type;

        private TableBucketMaintenanceConfigurationValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTableBucketMaintenanceConfigurationRequest model) {
            super(model);
            tableBucketARN(model.tableBucketARN);
            type(model.type);
            value(model.value);
        }

        public final String getTableBucketARN() {
            return tableBucketARN;
        }

        public final void setTableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
        }

        @Override
        public final Builder tableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TableBucketMaintenanceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final TableBucketMaintenanceConfigurationValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(TableBucketMaintenanceConfigurationValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(TableBucketMaintenanceConfigurationValue value) {
            this.value = value;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutTableBucketMaintenanceConfigurationRequest build() {
            return new PutTableBucketMaintenanceConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
