/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class TableBucketMaintenanceConfigurationCopier {
    static Map<String, TableBucketMaintenanceConfigurationValue> copy(
            Map<String, ? extends TableBucketMaintenanceConfigurationValue> tableBucketMaintenanceConfigurationParam) {
        Map<String, TableBucketMaintenanceConfigurationValue> map;
        if (tableBucketMaintenanceConfigurationParam == null
                || tableBucketMaintenanceConfigurationParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, TableBucketMaintenanceConfigurationValue> modifiableMap = new LinkedHashMap<>(
                    tableBucketMaintenanceConfigurationParam.size());
            tableBucketMaintenanceConfigurationParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, TableBucketMaintenanceConfigurationValue> copyFromBuilder(
            Map<String, ? extends TableBucketMaintenanceConfigurationValue.Builder> tableBucketMaintenanceConfigurationParam) {
        Map<String, TableBucketMaintenanceConfigurationValue> map;
        if (tableBucketMaintenanceConfigurationParam == null
                || tableBucketMaintenanceConfigurationParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, TableBucketMaintenanceConfigurationValue> modifiableMap = new LinkedHashMap<>(
                    tableBucketMaintenanceConfigurationParam.size());
            tableBucketMaintenanceConfigurationParam.forEach((key, value) -> {
                TableBucketMaintenanceConfigurationValue member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, TableBucketMaintenanceConfigurationValue.Builder> copyToBuilder(
            Map<String, ? extends TableBucketMaintenanceConfigurationValue> tableBucketMaintenanceConfigurationParam) {
        Map<String, TableBucketMaintenanceConfigurationValue.Builder> map;
        if (tableBucketMaintenanceConfigurationParam == null
                || tableBucketMaintenanceConfigurationParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, TableBucketMaintenanceConfigurationValue.Builder> modifiableMap = new LinkedHashMap<>(
                    tableBucketMaintenanceConfigurationParam.size());
            tableBucketMaintenanceConfigurationParam.forEach((key, value) -> {
                TableBucketMaintenanceConfigurationValue.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, TableBucketMaintenanceConfigurationValue> copyEnumToString(
            Map<TableBucketMaintenanceType, ? extends TableBucketMaintenanceConfigurationValue> tableBucketMaintenanceConfigurationParam) {
        Map<String, TableBucketMaintenanceConfigurationValue> map;
        if (tableBucketMaintenanceConfigurationParam == null
                || tableBucketMaintenanceConfigurationParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, TableBucketMaintenanceConfigurationValue> modifiableMap = new LinkedHashMap<>(
                    tableBucketMaintenanceConfigurationParam.size());
            tableBucketMaintenanceConfigurationParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<TableBucketMaintenanceType, TableBucketMaintenanceConfigurationValue> copyStringToEnum(
            Map<String, ? extends TableBucketMaintenanceConfigurationValue> tableBucketMaintenanceConfigurationParam) {
        Map<TableBucketMaintenanceType, TableBucketMaintenanceConfigurationValue> map;
        if (tableBucketMaintenanceConfigurationParam == null
                || tableBucketMaintenanceConfigurationParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<TableBucketMaintenanceType, TableBucketMaintenanceConfigurationValue> modifiableMap = new LinkedHashMap<>(
                    tableBucketMaintenanceConfigurationParam.size());
            tableBucketMaintenanceConfigurationParam.forEach((key, value) -> {
                TableBucketMaintenanceType result = TableBucketMaintenanceType.fromValue(key);
                if (result != TableBucketMaintenanceType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
