/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about maintenance settings for the table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableMaintenanceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<TableMaintenanceSettings.Builder, TableMaintenanceSettings> {
    private static final SdkField<IcebergCompactionSettings> ICEBERG_COMPACTION_FIELD = SdkField
            .<IcebergCompactionSettings> builder(MarshallingType.SDK_POJO).memberName("icebergCompaction")
            .getter(getter(TableMaintenanceSettings::icebergCompaction)).setter(setter(Builder::icebergCompaction))
            .constructor(IcebergCompactionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("icebergCompaction").build()).build();

    private static final SdkField<IcebergSnapshotManagementSettings> ICEBERG_SNAPSHOT_MANAGEMENT_FIELD = SdkField
            .<IcebergSnapshotManagementSettings> builder(MarshallingType.SDK_POJO).memberName("icebergSnapshotManagement")
            .getter(getter(TableMaintenanceSettings::icebergSnapshotManagement))
            .setter(setter(Builder::icebergSnapshotManagement)).constructor(IcebergSnapshotManagementSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("icebergSnapshotManagement").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ICEBERG_COMPACTION_FIELD,
            ICEBERG_SNAPSHOT_MANAGEMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("icebergCompaction", ICEBERG_COMPACTION_FIELD);
                    put("icebergSnapshotManagement", ICEBERG_SNAPSHOT_MANAGEMENT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final IcebergCompactionSettings icebergCompaction;

    private final IcebergSnapshotManagementSettings icebergSnapshotManagement;

    private final Type type;

    private TableMaintenanceSettings(BuilderImpl builder) {
        this.icebergCompaction = builder.icebergCompaction;
        this.icebergSnapshotManagement = builder.icebergSnapshotManagement;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains details about the Iceberg compaction settings for the table.
     * </p>
     * 
     * @return Contains details about the Iceberg compaction settings for the table.
     */
    public final IcebergCompactionSettings icebergCompaction() {
        return icebergCompaction;
    }

    /**
     * <p>
     * Contains details about the Iceberg snapshot management settings for the table.
     * </p>
     * 
     * @return Contains details about the Iceberg snapshot management settings for the table.
     */
    public final IcebergSnapshotManagementSettings icebergSnapshotManagement() {
        return icebergSnapshotManagement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(icebergCompaction());
        hashCode = 31 * hashCode + Objects.hashCode(icebergSnapshotManagement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableMaintenanceSettings)) {
            return false;
        }
        TableMaintenanceSettings other = (TableMaintenanceSettings) obj;
        return Objects.equals(icebergCompaction(), other.icebergCompaction())
                && Objects.equals(icebergSnapshotManagement(), other.icebergSnapshotManagement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableMaintenanceSettings").add("IcebergCompaction", icebergCompaction())
                .add("IcebergSnapshotManagement", icebergSnapshotManagement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "icebergCompaction":
            return Optional.ofNullable(clazz.cast(icebergCompaction()));
        case "icebergSnapshotManagement":
            return Optional.ofNullable(clazz.cast(icebergSnapshotManagement()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #icebergCompaction()} initialized to the given value.
     *
     * <p>
     * Contains details about the Iceberg compaction settings for the table.
     * </p>
     * 
     * @param icebergCompaction
     *        Contains details about the Iceberg compaction settings for the table.
     */
    public static TableMaintenanceSettings fromIcebergCompaction(IcebergCompactionSettings icebergCompaction) {
        return builder().icebergCompaction(icebergCompaction).build();
    }

    /**
     * Create an instance of this class with {@link #icebergCompaction()} initialized to the given value.
     *
     * <p>
     * Contains details about the Iceberg compaction settings for the table.
     * </p>
     * 
     * @param icebergCompaction
     *        Contains details about the Iceberg compaction settings for the table.
     */
    public static TableMaintenanceSettings fromIcebergCompaction(Consumer<IcebergCompactionSettings.Builder> icebergCompaction) {
        IcebergCompactionSettings.Builder builder = IcebergCompactionSettings.builder();
        icebergCompaction.accept(builder);
        return fromIcebergCompaction(builder.build());
    }

    /**
     * Create an instance of this class with {@link #icebergSnapshotManagement()} initialized to the given value.
     *
     * <p>
     * Contains details about the Iceberg snapshot management settings for the table.
     * </p>
     * 
     * @param icebergSnapshotManagement
     *        Contains details about the Iceberg snapshot management settings for the table.
     */
    public static TableMaintenanceSettings fromIcebergSnapshotManagement(
            IcebergSnapshotManagementSettings icebergSnapshotManagement) {
        return builder().icebergSnapshotManagement(icebergSnapshotManagement).build();
    }

    /**
     * Create an instance of this class with {@link #icebergSnapshotManagement()} initialized to the given value.
     *
     * <p>
     * Contains details about the Iceberg snapshot management settings for the table.
     * </p>
     * 
     * @param icebergSnapshotManagement
     *        Contains details about the Iceberg snapshot management settings for the table.
     */
    public static TableMaintenanceSettings fromIcebergSnapshotManagement(
            Consumer<IcebergSnapshotManagementSettings.Builder> icebergSnapshotManagement) {
        IcebergSnapshotManagementSettings.Builder builder = IcebergSnapshotManagementSettings.builder();
        icebergSnapshotManagement.accept(builder);
        return fromIcebergSnapshotManagement(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TableMaintenanceSettings, T> g) {
        return obj -> g.apply((TableMaintenanceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableMaintenanceSettings> {
        /**
         * <p>
         * Contains details about the Iceberg compaction settings for the table.
         * </p>
         * 
         * @param icebergCompaction
         *        Contains details about the Iceberg compaction settings for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder icebergCompaction(IcebergCompactionSettings icebergCompaction);

        /**
         * <p>
         * Contains details about the Iceberg compaction settings for the table.
         * </p>
         * This is a convenience method that creates an instance of the {@link IcebergCompactionSettings.Builder}
         * avoiding the need to create one manually via {@link IcebergCompactionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IcebergCompactionSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #icebergCompaction(IcebergCompactionSettings)}.
         * 
         * @param icebergCompaction
         *        a consumer that will call methods on {@link IcebergCompactionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #icebergCompaction(IcebergCompactionSettings)
         */
        default Builder icebergCompaction(Consumer<IcebergCompactionSettings.Builder> icebergCompaction) {
            return icebergCompaction(IcebergCompactionSettings.builder().applyMutation(icebergCompaction).build());
        }

        /**
         * <p>
         * Contains details about the Iceberg snapshot management settings for the table.
         * </p>
         * 
         * @param icebergSnapshotManagement
         *        Contains details about the Iceberg snapshot management settings for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder icebergSnapshotManagement(IcebergSnapshotManagementSettings icebergSnapshotManagement);

        /**
         * <p>
         * Contains details about the Iceberg snapshot management settings for the table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IcebergSnapshotManagementSettings.Builder} avoiding the need to create one manually via
         * {@link IcebergSnapshotManagementSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IcebergSnapshotManagementSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #icebergSnapshotManagement(IcebergSnapshotManagementSettings)}.
         * 
         * @param icebergSnapshotManagement
         *        a consumer that will call methods on {@link IcebergSnapshotManagementSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #icebergSnapshotManagement(IcebergSnapshotManagementSettings)
         */
        default Builder icebergSnapshotManagement(Consumer<IcebergSnapshotManagementSettings.Builder> icebergSnapshotManagement) {
            return icebergSnapshotManagement(IcebergSnapshotManagementSettings.builder().applyMutation(icebergSnapshotManagement)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IcebergCompactionSettings icebergCompaction;

        private IcebergSnapshotManagementSettings icebergSnapshotManagement;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TableMaintenanceSettings model) {
            icebergCompaction(model.icebergCompaction);
            icebergSnapshotManagement(model.icebergSnapshotManagement);
        }

        public final IcebergCompactionSettings.Builder getIcebergCompaction() {
            return icebergCompaction != null ? icebergCompaction.toBuilder() : null;
        }

        public final void setIcebergCompaction(IcebergCompactionSettings.BuilderImpl icebergCompaction) {
            Object oldValue = this.icebergCompaction;
            this.icebergCompaction = icebergCompaction != null ? icebergCompaction.build() : null;
            handleUnionValueChange(Type.ICEBERG_COMPACTION, oldValue, this.icebergCompaction);
        }

        @Override
        public final Builder icebergCompaction(IcebergCompactionSettings icebergCompaction) {
            Object oldValue = this.icebergCompaction;
            this.icebergCompaction = icebergCompaction;
            handleUnionValueChange(Type.ICEBERG_COMPACTION, oldValue, this.icebergCompaction);
            return this;
        }

        public final IcebergSnapshotManagementSettings.Builder getIcebergSnapshotManagement() {
            return icebergSnapshotManagement != null ? icebergSnapshotManagement.toBuilder() : null;
        }

        public final void setIcebergSnapshotManagement(IcebergSnapshotManagementSettings.BuilderImpl icebergSnapshotManagement) {
            Object oldValue = this.icebergSnapshotManagement;
            this.icebergSnapshotManagement = icebergSnapshotManagement != null ? icebergSnapshotManagement.build() : null;
            handleUnionValueChange(Type.ICEBERG_SNAPSHOT_MANAGEMENT, oldValue, this.icebergSnapshotManagement);
        }

        @Override
        public final Builder icebergSnapshotManagement(IcebergSnapshotManagementSettings icebergSnapshotManagement) {
            Object oldValue = this.icebergSnapshotManagement;
            this.icebergSnapshotManagement = icebergSnapshotManagement;
            handleUnionValueChange(Type.ICEBERG_SNAPSHOT_MANAGEMENT, oldValue, this.icebergSnapshotManagement);
            return this;
        }

        @Override
        public TableMaintenanceSettings build() {
            return new TableMaintenanceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see TableMaintenanceSettings#type()
     */
    public enum Type {
        ICEBERG_COMPACTION,

        ICEBERG_SNAPSHOT_MANAGEMENT,

        UNKNOWN_TO_SDK_VERSION
    }
}
