/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTableMetadataLocationResponse extends S3TablesResponse implements
        ToCopyableBuilder<UpdateTableMetadataLocationResponse.Builder, UpdateTableMetadataLocationResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateTableMetadataLocationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableARN").getter(getter(UpdateTableMetadataLocationResponse::tableARN))
            .setter(setter(Builder::tableARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableARN").build()).build();

    private static final SdkField<List<String>> NAMESPACE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("namespace")
            .getter(getter(UpdateTableMetadataLocationResponse::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VERSION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionToken").getter(getter(UpdateTableMetadataLocationResponse::versionToken))
            .setter(setter(Builder::versionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionToken").build()).build();

    private static final SdkField<String> METADATA_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metadataLocation").getter(getter(UpdateTableMetadataLocationResponse::metadataLocation))
            .setter(setter(Builder::metadataLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TABLE_ARN_FIELD,
            NAMESPACE_FIELD, VERSION_TOKEN_FIELD, METADATA_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("name", NAME_FIELD);
                    put("tableARN", TABLE_ARN_FIELD);
                    put("namespace", NAMESPACE_FIELD);
                    put("versionToken", VERSION_TOKEN_FIELD);
                    put("metadataLocation", METADATA_LOCATION_FIELD);
                }
            });

    private final String name;

    private final String tableARN;

    private final List<String> namespace;

    private final String versionToken;

    private final String metadataLocation;

    private UpdateTableMetadataLocationResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.tableARN = builder.tableARN;
        this.namespace = builder.namespace;
        this.versionToken = builder.versionToken;
        this.metadataLocation = builder.metadataLocation;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the table.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the table.
     */
    public final String tableARN() {
        return tableARN;
    }

    /**
     * For responses, this returns true if the service returned a value for the Namespace property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNamespace() {
        return namespace != null && !(namespace instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The namespace the table is associated with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNamespace} method.
     * </p>
     * 
     * @return The namespace the table is associated with.
     */
    public final List<String> namespace() {
        return namespace;
    }

    /**
     * <p>
     * The version token of the table.
     * </p>
     * 
     * @return The version token of the table.
     */
    public final String versionToken() {
        return versionToken;
    }

    /**
     * <p>
     * The metadata location of the table.
     * </p>
     * 
     * @return The metadata location of the table.
     */
    public final String metadataLocation() {
        return metadataLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(tableARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasNamespace() ? namespace() : null);
        hashCode = 31 * hashCode + Objects.hashCode(versionToken());
        hashCode = 31 * hashCode + Objects.hashCode(metadataLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableMetadataLocationResponse)) {
            return false;
        }
        UpdateTableMetadataLocationResponse other = (UpdateTableMetadataLocationResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(tableARN(), other.tableARN())
                && hasNamespace() == other.hasNamespace() && Objects.equals(namespace(), other.namespace())
                && Objects.equals(versionToken(), other.versionToken())
                && Objects.equals(metadataLocation(), other.metadataLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTableMetadataLocationResponse").add("Name", name()).add("TableARN", tableARN())
                .add("Namespace", hasNamespace() ? namespace() : null).add("VersionToken", versionToken())
                .add("MetadataLocation", metadataLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tableARN":
            return Optional.ofNullable(clazz.cast(tableARN()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "versionToken":
            return Optional.ofNullable(clazz.cast(versionToken()));
        case "metadataLocation":
            return Optional.ofNullable(clazz.cast(metadataLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableMetadataLocationResponse, T> g) {
        return obj -> g.apply((UpdateTableMetadataLocationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3TablesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateTableMetadataLocationResponse> {
        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param name
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the table.
         * </p>
         * 
         * @param tableARN
         *        The Amazon Resource Number (ARN) of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableARN(String tableARN);

        /**
         * <p>
         * The namespace the table is associated with.
         * </p>
         * 
         * @param namespace
         *        The namespace the table is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(Collection<String> namespace);

        /**
         * <p>
         * The namespace the table is associated with.
         * </p>
         * 
         * @param namespace
         *        The namespace the table is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String... namespace);

        /**
         * <p>
         * The version token of the table.
         * </p>
         * 
         * @param versionToken
         *        The version token of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionToken(String versionToken);

        /**
         * <p>
         * The metadata location of the table.
         * </p>
         * 
         * @param metadataLocation
         *        The metadata location of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataLocation(String metadataLocation);
    }

    static final class BuilderImpl extends S3TablesResponse.BuilderImpl implements Builder {
        private String name;

        private String tableARN;

        private List<String> namespace = DefaultSdkAutoConstructList.getInstance();

        private String versionToken;

        private String metadataLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableMetadataLocationResponse model) {
            super(model);
            name(model.name);
            tableARN(model.tableARN);
            namespace(model.namespace);
            versionToken(model.versionToken);
            metadataLocation(model.metadataLocation);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTableARN() {
            return tableARN;
        }

        public final void setTableARN(String tableARN) {
            this.tableARN = tableARN;
        }

        @Override
        public final Builder tableARN(String tableARN) {
            this.tableARN = tableARN;
            return this;
        }

        public final Collection<String> getNamespace() {
            if (namespace instanceof SdkAutoConstructList) {
                return null;
            }
            return namespace;
        }

        public final void setNamespace(Collection<String> namespace) {
            this.namespace = NamespaceListCopier.copy(namespace);
        }

        @Override
        public final Builder namespace(Collection<String> namespace) {
            this.namespace = NamespaceListCopier.copy(namespace);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespace(String... namespace) {
            namespace(Arrays.asList(namespace));
            return this;
        }

        public final String getVersionToken() {
            return versionToken;
        }

        public final void setVersionToken(String versionToken) {
            this.versionToken = versionToken;
        }

        @Override
        public final Builder versionToken(String versionToken) {
            this.versionToken = versionToken;
            return this;
        }

        public final String getMetadataLocation() {
            return metadataLocation;
        }

        public final void setMetadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
        }

        @Override
        public final Builder metadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
            return this;
        }

        @Override
        public UpdateTableMetadataLocationResponse build() {
            return new UpdateTableMetadataLocationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
