/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3tables.model.S3TablesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTableMetadataLocationResponse
extends S3TablesResponse
implements ToCopyableBuilder<Builder, GetTableMetadataLocationResponse> {
    private static final SdkField<String> VERSION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionToken").getter(GetTableMetadataLocationResponse.getter(GetTableMetadataLocationResponse::versionToken)).setter(GetTableMetadataLocationResponse.setter(Builder::versionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionToken").build()}).build();
    private static final SdkField<String> METADATA_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metadataLocation").getter(GetTableMetadataLocationResponse.getter(GetTableMetadataLocationResponse::metadataLocation)).setter(GetTableMetadataLocationResponse.setter(Builder::metadataLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataLocation").build()}).build();
    private static final SdkField<String> WAREHOUSE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("warehouseLocation").getter(GetTableMetadataLocationResponse.getter(GetTableMetadataLocationResponse::warehouseLocation)).setter(GetTableMetadataLocationResponse.setter(Builder::warehouseLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warehouseLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_TOKEN_FIELD, METADATA_LOCATION_FIELD, WAREHOUSE_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("versionToken", VERSION_TOKEN_FIELD);
            this.put("metadataLocation", METADATA_LOCATION_FIELD);
            this.put("warehouseLocation", WAREHOUSE_LOCATION_FIELD);
        }
    });
    private final String versionToken;
    private final String metadataLocation;
    private final String warehouseLocation;

    private GetTableMetadataLocationResponse(BuilderImpl builder) {
        super(builder);
        this.versionToken = builder.versionToken;
        this.metadataLocation = builder.metadataLocation;
        this.warehouseLocation = builder.warehouseLocation;
    }

    public final String versionToken() {
        return this.versionToken;
    }

    public final String metadataLocation() {
        return this.metadataLocation;
    }

    public final String warehouseLocation() {
        return this.warehouseLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.versionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.warehouseLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableMetadataLocationResponse)) {
            return false;
        }
        GetTableMetadataLocationResponse other = (GetTableMetadataLocationResponse)((Object)obj);
        return Objects.equals(this.versionToken(), other.versionToken()) && Objects.equals(this.metadataLocation(), other.metadataLocation()) && Objects.equals(this.warehouseLocation(), other.warehouseLocation());
    }

    public final String toString() {
        return ToString.builder((String)"GetTableMetadataLocationResponse").add("VersionToken", (Object)this.versionToken()).add("MetadataLocation", (Object)this.metadataLocation()).add("WarehouseLocation", (Object)this.warehouseLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "versionToken": {
                return Optional.ofNullable(clazz.cast(this.versionToken()));
            }
            case "metadataLocation": {
                return Optional.ofNullable(clazz.cast(this.metadataLocation()));
            }
            case "warehouseLocation": {
                return Optional.ofNullable(clazz.cast(this.warehouseLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTableMetadataLocationResponse, T> g) {
        return obj -> g.apply((GetTableMetadataLocationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesResponse.BuilderImpl
    implements Builder {
        private String versionToken;
        private String metadataLocation;
        private String warehouseLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableMetadataLocationResponse model) {
            super(model);
            this.versionToken(model.versionToken);
            this.metadataLocation(model.metadataLocation);
            this.warehouseLocation(model.warehouseLocation);
        }

        public final String getVersionToken() {
            return this.versionToken;
        }

        public final void setVersionToken(String versionToken) {
            this.versionToken = versionToken;
        }

        @Override
        public final Builder versionToken(String versionToken) {
            this.versionToken = versionToken;
            return this;
        }

        public final String getMetadataLocation() {
            return this.metadataLocation;
        }

        public final void setMetadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
        }

        @Override
        public final Builder metadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
            return this;
        }

        public final String getWarehouseLocation() {
            return this.warehouseLocation;
        }

        public final void setWarehouseLocation(String warehouseLocation) {
            this.warehouseLocation = warehouseLocation;
        }

        @Override
        public final Builder warehouseLocation(String warehouseLocation) {
            this.warehouseLocation = warehouseLocation;
            return this;
        }

        @Override
        public GetTableMetadataLocationResponse build() {
            return new GetTableMetadataLocationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3TablesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTableMetadataLocationResponse> {
        public Builder versionToken(String var1);

        public Builder metadataLocation(String var1);

        public Builder warehouseLocation(String var1);
    }
}

