/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.s3tables.model.IcebergMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableMetadata> {
    private static final SdkField<IcebergMetadata> ICEBERG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iceberg").getter(TableMetadata.getter(TableMetadata::iceberg)).setter(TableMetadata.setter(Builder::iceberg)).constructor(IcebergMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iceberg").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ICEBERG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TableMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final IcebergMetadata iceberg;
    private final Type type;

    private TableMetadata(BuilderImpl builder) {
        this.iceberg = builder.iceberg;
        this.type = builder.type;
    }

    public final IcebergMetadata iceberg() {
        return this.iceberg;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iceberg());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableMetadata)) {
            return false;
        }
        TableMetadata other = (TableMetadata)obj;
        return Objects.equals(this.iceberg(), other.iceberg());
    }

    public final String toString() {
        return ToString.builder((String)"TableMetadata").add("Iceberg", (Object)this.iceberg()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "iceberg": {
                return Optional.ofNullable(clazz.cast(this.iceberg()));
            }
        }
        return Optional.empty();
    }

    public static TableMetadata fromIceberg(IcebergMetadata iceberg) {
        return (TableMetadata)TableMetadata.builder().iceberg(iceberg).build();
    }

    public static TableMetadata fromIceberg(Consumer<IcebergMetadata.Builder> iceberg) {
        IcebergMetadata.Builder builder = IcebergMetadata.builder();
        iceberg.accept(builder);
        return TableMetadata.fromIceberg((IcebergMetadata)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<IcebergMetadata>> map = new HashMap<String, SdkField<IcebergMetadata>>();
        map.put("iceberg", ICEBERG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableMetadata, T> g) {
        return obj -> g.apply((TableMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ICEBERG,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private IcebergMetadata iceberg;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TableMetadata model) {
            this.iceberg(model.iceberg);
        }

        public final IcebergMetadata.Builder getIceberg() {
            return this.iceberg != null ? this.iceberg.toBuilder() : null;
        }

        public final void setIceberg(IcebergMetadata.BuilderImpl iceberg) {
            IcebergMetadata oldValue = this.iceberg;
            this.iceberg = iceberg != null ? iceberg.build() : null;
            this.handleUnionValueChange(Type.ICEBERG, oldValue, this.iceberg);
        }

        @Override
        public final Builder iceberg(IcebergMetadata iceberg) {
            IcebergMetadata oldValue = this.iceberg;
            this.iceberg = iceberg;
            this.handleUnionValueChange(Type.ICEBERG, oldValue, this.iceberg);
            return this;
        }

        public TableMetadata build() {
            return new TableMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableMetadata> {
        public Builder iceberg(IcebergMetadata var1);

        default public Builder iceberg(Consumer<IcebergMetadata.Builder> iceberg) {
            return this.iceberg((IcebergMetadata)((IcebergMetadata.Builder)IcebergMetadata.builder().applyMutation(iceberg)).build());
        }
    }
}

