/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3tables.S3TablesClient;
import software.amazon.awssdk.services.s3tables.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3tables.model.ListTableBucketsRequest;
import software.amazon.awssdk.services.s3tables.model.ListTableBucketsResponse;
import software.amazon.awssdk.services.s3tables.model.TableBucketSummary;

public class ListTableBucketsIterable
implements SdkIterable<ListTableBucketsResponse> {
    private final S3TablesClient client;
    private final ListTableBucketsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTableBucketsIterable(S3TablesClient client, ListTableBucketsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTableBucketsResponseFetcher();
    }

    public Iterator<ListTableBucketsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TableBucketSummary> tableBuckets() {
        Function<ListTableBucketsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tableBuckets() != null) {
                return response.tableBuckets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTableBucketsResponseFetcher
    implements SyncPageFetcher<ListTableBucketsResponse> {
        private ListTableBucketsResponseFetcher() {
        }

        public boolean hasNextPage(ListTableBucketsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.continuationToken());
        }

        public ListTableBucketsResponse nextPage(ListTableBucketsResponse previousPage) {
            if (previousPage == null) {
                return ListTableBucketsIterable.this.client.listTableBuckets(ListTableBucketsIterable.this.firstRequest);
            }
            return ListTableBucketsIterable.this.client.listTableBuckets((ListTableBucketsRequest)((Object)ListTableBucketsIterable.this.firstRequest.toBuilder().continuationToken(previousPage.continuationToken()).build()));
        }
    }
}

