/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3tables.model.S3TablesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutTableBucketReplicationResponse
extends S3TablesResponse
implements ToCopyableBuilder<Builder, PutTableBucketReplicationResponse> {
    private static final SdkField<String> VERSION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionToken").getter(PutTableBucketReplicationResponse.getter(PutTableBucketReplicationResponse::versionToken)).setter(PutTableBucketReplicationResponse.setter(Builder::versionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionToken").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(PutTableBucketReplicationResponse.getter(PutTableBucketReplicationResponse::status)).setter(PutTableBucketReplicationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_TOKEN_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutTableBucketReplicationResponse.memberNameToFieldInitializer();
    private final String versionToken;
    private final String status;

    private PutTableBucketReplicationResponse(BuilderImpl builder) {
        super(builder);
        this.versionToken = builder.versionToken;
        this.status = builder.status;
    }

    public final String versionToken() {
        return this.versionToken;
    }

    public final String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.versionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTableBucketReplicationResponse)) {
            return false;
        }
        PutTableBucketReplicationResponse other = (PutTableBucketReplicationResponse)((Object)obj);
        return Objects.equals(this.versionToken(), other.versionToken()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"PutTableBucketReplicationResponse").add("VersionToken", (Object)this.versionToken()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "versionToken": {
                return Optional.ofNullable(clazz.cast(this.versionToken()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("versionToken", VERSION_TOKEN_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutTableBucketReplicationResponse, T> g) {
        return obj -> g.apply((PutTableBucketReplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesResponse.BuilderImpl
    implements Builder {
        private String versionToken;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTableBucketReplicationResponse model) {
            super(model);
            this.versionToken(model.versionToken);
            this.status(model.status);
        }

        public final String getVersionToken() {
            return this.versionToken;
        }

        public final void setVersionToken(String versionToken) {
            this.versionToken = versionToken;
        }

        @Override
        public final Builder versionToken(String versionToken) {
            this.versionToken = versionToken;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public PutTableBucketReplicationResponse build() {
            return new PutTableBucketReplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3TablesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutTableBucketReplicationResponse> {
        public Builder versionToken(String var1);

        public Builder status(String var1);
    }
}

