/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableRecordExpirationJobMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableRecordExpirationJobMetrics> {
    private static final SdkField<Long> DELETED_DATA_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("deletedDataFiles").getter(TableRecordExpirationJobMetrics.getter(TableRecordExpirationJobMetrics::deletedDataFiles)).setter(TableRecordExpirationJobMetrics.setter(Builder::deletedDataFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletedDataFiles").build()}).build();
    private static final SdkField<Long> DELETED_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("deletedRecords").getter(TableRecordExpirationJobMetrics.getter(TableRecordExpirationJobMetrics::deletedRecords)).setter(TableRecordExpirationJobMetrics.setter(Builder::deletedRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletedRecords").build()}).build();
    private static final SdkField<Long> REMOVED_FILES_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("removedFilesSize").getter(TableRecordExpirationJobMetrics.getter(TableRecordExpirationJobMetrics::removedFilesSize)).setter(TableRecordExpirationJobMetrics.setter(Builder::removedFilesSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removedFilesSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETED_DATA_FILES_FIELD, DELETED_RECORDS_FIELD, REMOVED_FILES_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TableRecordExpirationJobMetrics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long deletedDataFiles;
    private final Long deletedRecords;
    private final Long removedFilesSize;

    private TableRecordExpirationJobMetrics(BuilderImpl builder) {
        this.deletedDataFiles = builder.deletedDataFiles;
        this.deletedRecords = builder.deletedRecords;
        this.removedFilesSize = builder.removedFilesSize;
    }

    public final Long deletedDataFiles() {
        return this.deletedDataFiles;
    }

    public final Long deletedRecords() {
        return this.deletedRecords;
    }

    public final Long removedFilesSize() {
        return this.removedFilesSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deletedDataFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletedRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.removedFilesSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableRecordExpirationJobMetrics)) {
            return false;
        }
        TableRecordExpirationJobMetrics other = (TableRecordExpirationJobMetrics)obj;
        return Objects.equals(this.deletedDataFiles(), other.deletedDataFiles()) && Objects.equals(this.deletedRecords(), other.deletedRecords()) && Objects.equals(this.removedFilesSize(), other.removedFilesSize());
    }

    public final String toString() {
        return ToString.builder((String)"TableRecordExpirationJobMetrics").add("DeletedDataFiles", (Object)this.deletedDataFiles()).add("DeletedRecords", (Object)this.deletedRecords()).add("RemovedFilesSize", (Object)this.removedFilesSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deletedDataFiles": {
                return Optional.ofNullable(clazz.cast(this.deletedDataFiles()));
            }
            case "deletedRecords": {
                return Optional.ofNullable(clazz.cast(this.deletedRecords()));
            }
            case "removedFilesSize": {
                return Optional.ofNullable(clazz.cast(this.removedFilesSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Long>> map = new HashMap<String, SdkField<Long>>();
        map.put("deletedDataFiles", DELETED_DATA_FILES_FIELD);
        map.put("deletedRecords", DELETED_RECORDS_FIELD);
        map.put("removedFilesSize", REMOVED_FILES_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableRecordExpirationJobMetrics, T> g) {
        return obj -> g.apply((TableRecordExpirationJobMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long deletedDataFiles;
        private Long deletedRecords;
        private Long removedFilesSize;

        private BuilderImpl() {
        }

        private BuilderImpl(TableRecordExpirationJobMetrics model) {
            this.deletedDataFiles(model.deletedDataFiles);
            this.deletedRecords(model.deletedRecords);
            this.removedFilesSize(model.removedFilesSize);
        }

        public final Long getDeletedDataFiles() {
            return this.deletedDataFiles;
        }

        public final void setDeletedDataFiles(Long deletedDataFiles) {
            this.deletedDataFiles = deletedDataFiles;
        }

        @Override
        public final Builder deletedDataFiles(Long deletedDataFiles) {
            this.deletedDataFiles = deletedDataFiles;
            return this;
        }

        public final Long getDeletedRecords() {
            return this.deletedRecords;
        }

        public final void setDeletedRecords(Long deletedRecords) {
            this.deletedRecords = deletedRecords;
        }

        @Override
        public final Builder deletedRecords(Long deletedRecords) {
            this.deletedRecords = deletedRecords;
            return this;
        }

        public final Long getRemovedFilesSize() {
            return this.removedFilesSize;
        }

        public final void setRemovedFilesSize(Long removedFilesSize) {
            this.removedFilesSize = removedFilesSize;
        }

        @Override
        public final Builder removedFilesSize(Long removedFilesSize) {
            this.removedFilesSize = removedFilesSize;
            return this;
        }

        public TableRecordExpirationJobMetrics build() {
            return new TableRecordExpirationJobMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableRecordExpirationJobMetrics> {
        public Builder deletedDataFiles(Long var1);

        public Builder deletedRecords(Long var1);

        public Builder removedFilesSize(Long var1);
    }
}

