/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3tables.model.NamespaceListCopier;
import software.amazon.awssdk.services.s3tables.model.TableType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableSummary> {
    private static final SdkField<List<String>> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("namespace").getter(TableSummary.getter(TableSummary::namespace)).setter(TableSummary.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(TableSummary.getter(TableSummary::name)).setter(TableSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(TableSummary.getter(TableSummary::typeAsString)).setter(TableSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableARN").getter(TableSummary.getter(TableSummary::tableARN)).setter(TableSummary.setter(Builder::tableARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableARN").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(TableSummary.getter(TableSummary::createdAt)).setter(TableSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(TableSummary.getter(TableSummary::modifiedAt)).setter(TableSummary.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> MANAGED_BY_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedByService").getter(TableSummary.getter(TableSummary::managedByService)).setter(TableSummary.setter(Builder::managedByService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedByService").build()}).build();
    private static final SdkField<String> NAMESPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceId").getter(TableSummary.getter(TableSummary::namespaceId)).setter(TableSummary.setter(Builder::namespaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceId").build()}).build();
    private static final SdkField<String> TABLE_BUCKET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableBucketId").getter(TableSummary.getter(TableSummary::tableBucketId)).setter(TableSummary.setter(Builder::tableBucketId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableBucketId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, NAME_FIELD, TYPE_FIELD, TABLE_ARN_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, MANAGED_BY_SERVICE_FIELD, NAMESPACE_ID_FIELD, TABLE_BUCKET_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TableSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> namespace;
    private final String name;
    private final String type;
    private final String tableARN;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final String managedByService;
    private final String namespaceId;
    private final String tableBucketId;

    private TableSummary(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.type = builder.type;
        this.tableARN = builder.tableARN;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.managedByService = builder.managedByService;
        this.namespaceId = builder.namespaceId;
        this.tableBucketId = builder.tableBucketId;
    }

    public final boolean hasNamespace() {
        return this.namespace != null && !(this.namespace instanceof SdkAutoConstructList);
    }

    public final List<String> namespace() {
        return this.namespace;
    }

    public final String name() {
        return this.name;
    }

    public final TableType type() {
        return TableType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String tableARN() {
        return this.tableARN;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final String managedByService() {
        return this.managedByService;
    }

    public final String namespaceId() {
        return this.namespaceId;
    }

    public final String tableBucketId() {
        return this.tableBucketId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNamespace() ? this.namespace() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedByService());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableBucketId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableSummary)) {
            return false;
        }
        TableSummary other = (TableSummary)obj;
        return this.hasNamespace() == other.hasNamespace() && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.tableARN(), other.tableARN()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.managedByService(), other.managedByService()) && Objects.equals(this.namespaceId(), other.namespaceId()) && Objects.equals(this.tableBucketId(), other.tableBucketId());
    }

    public final String toString() {
        return ToString.builder((String)"TableSummary").add("Namespace", this.hasNamespace() ? this.namespace() : null).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("TableARN", (Object)this.tableARN()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("ManagedByService", (Object)this.managedByService()).add("NamespaceId", (Object)this.namespaceId()).add("TableBucketId", (Object)this.tableBucketId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "tableARN": {
                return Optional.ofNullable(clazz.cast(this.tableARN()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "managedByService": {
                return Optional.ofNullable(clazz.cast(this.managedByService()));
            }
            case "namespaceId": {
                return Optional.ofNullable(clazz.cast(this.namespaceId()));
            }
            case "tableBucketId": {
                return Optional.ofNullable(clazz.cast(this.tableBucketId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("namespace", NAMESPACE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("tableARN", TABLE_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("managedByService", MANAGED_BY_SERVICE_FIELD);
        map.put("namespaceId", NAMESPACE_ID_FIELD);
        map.put("tableBucketId", TABLE_BUCKET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableSummary, T> g) {
        return obj -> g.apply((TableSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> namespace = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String type;
        private String tableARN;
        private Instant createdAt;
        private Instant modifiedAt;
        private String managedByService;
        private String namespaceId;
        private String tableBucketId;

        private BuilderImpl() {
        }

        private BuilderImpl(TableSummary model) {
            this.namespace(model.namespace);
            this.name(model.name);
            this.type(model.type);
            this.tableARN(model.tableARN);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.managedByService(model.managedByService);
            this.namespaceId(model.namespaceId);
            this.tableBucketId(model.tableBucketId);
        }

        public final Collection<String> getNamespace() {
            if (this.namespace instanceof SdkAutoConstructList) {
                return null;
            }
            return this.namespace;
        }

        public final void setNamespace(Collection<String> namespace) {
            this.namespace = NamespaceListCopier.copy(namespace);
        }

        @Override
        public final Builder namespace(Collection<String> namespace) {
            this.namespace = NamespaceListCopier.copy(namespace);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespace(String ... namespace) {
            this.namespace(Arrays.asList(namespace));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TableType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getTableARN() {
            return this.tableARN;
        }

        public final void setTableARN(String tableARN) {
            this.tableARN = tableARN;
        }

        @Override
        public final Builder tableARN(String tableARN) {
            this.tableARN = tableARN;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getManagedByService() {
            return this.managedByService;
        }

        public final void setManagedByService(String managedByService) {
            this.managedByService = managedByService;
        }

        @Override
        public final Builder managedByService(String managedByService) {
            this.managedByService = managedByService;
            return this;
        }

        public final String getNamespaceId() {
            return this.namespaceId;
        }

        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        @Override
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public final String getTableBucketId() {
            return this.tableBucketId;
        }

        public final void setTableBucketId(String tableBucketId) {
            this.tableBucketId = tableBucketId;
        }

        @Override
        public final Builder tableBucketId(String tableBucketId) {
            this.tableBucketId = tableBucketId;
            return this;
        }

        public TableSummary build() {
            return new TableSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableSummary> {
        public Builder namespace(Collection<String> var1);

        public Builder namespace(String ... var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(TableType var1);

        public Builder tableARN(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder managedByService(String var1);

        public Builder namespaceId(String var1);

        public Builder tableBucketId(String var1);
    }
}

