/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3vectors.S3VectorsAsyncClient;
import software.amazon.awssdk.services.s3vectors.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3vectors.model.IndexSummary;
import software.amazon.awssdk.services.s3vectors.model.ListIndexesRequest;
import software.amazon.awssdk.services.s3vectors.model.ListIndexesResponse;

public class ListIndexesPublisher
implements SdkPublisher<ListIndexesResponse> {
    private final S3VectorsAsyncClient client;
    private final ListIndexesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIndexesPublisher(S3VectorsAsyncClient client, ListIndexesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIndexesPublisher(S3VectorsAsyncClient client, ListIndexesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIndexesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIndexesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IndexSummary> indexes() {
        return this.flatMapIterable(response -> response.indexes());
    }

    private class ListIndexesResponseFetcher
    implements AsyncPageFetcher<ListIndexesResponse> {
        private ListIndexesResponseFetcher() {
        }

        public boolean hasNextPage(ListIndexesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIndexesResponse> nextPage(ListIndexesResponse previousPage) {
            if (previousPage == null) {
                return ListIndexesPublisher.this.client.listIndexes(ListIndexesPublisher.this.firstRequest);
            }
            return ListIndexesPublisher.this.client.listIndexes((ListIndexesRequest)((Object)ListIndexesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

