/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3vectors.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3vectors.model.ListVectorBucketsOutputListCopier;
import software.amazon.awssdk.services.s3vectors.model.S3VectorsResponse;
import software.amazon.awssdk.services.s3vectors.model.VectorBucketSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVectorBucketsResponse
extends S3VectorsResponse
implements ToCopyableBuilder<Builder, ListVectorBucketsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListVectorBucketsResponse.getter(ListVectorBucketsResponse::nextToken)).setter(ListVectorBucketsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<VectorBucketSummary>> VECTOR_BUCKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vectorBuckets").getter(ListVectorBucketsResponse.getter(ListVectorBucketsResponse::vectorBuckets)).setter(ListVectorBucketsResponse.setter(Builder::vectorBuckets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBuckets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VectorBucketSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, VECTOR_BUCKETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListVectorBucketsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<VectorBucketSummary> vectorBuckets;

    private ListVectorBucketsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.vectorBuckets = builder.vectorBuckets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasVectorBuckets() {
        return this.vectorBuckets != null && !(this.vectorBuckets instanceof SdkAutoConstructList);
    }

    public final List<VectorBucketSummary> vectorBuckets() {
        return this.vectorBuckets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVectorBuckets() ? this.vectorBuckets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVectorBucketsResponse)) {
            return false;
        }
        ListVectorBucketsResponse other = (ListVectorBucketsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasVectorBuckets() == other.hasVectorBuckets() && Objects.equals(this.vectorBuckets(), other.vectorBuckets());
    }

    public final String toString() {
        return ToString.builder((String)"ListVectorBucketsResponse").add("NextToken", (Object)this.nextToken()).add("VectorBuckets", this.hasVectorBuckets() ? this.vectorBuckets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "vectorBuckets": {
                return Optional.ofNullable(clazz.cast(this.vectorBuckets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("vectorBuckets", VECTOR_BUCKETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVectorBucketsResponse, T> g) {
        return obj -> g.apply((ListVectorBucketsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3VectorsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VectorBucketSummary> vectorBuckets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVectorBucketsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.vectorBuckets(model.vectorBuckets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<VectorBucketSummary.Builder> getVectorBuckets() {
            List<VectorBucketSummary.Builder> result = ListVectorBucketsOutputListCopier.copyToBuilder(this.vectorBuckets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVectorBuckets(Collection<VectorBucketSummary.BuilderImpl> vectorBuckets) {
            this.vectorBuckets = ListVectorBucketsOutputListCopier.copyFromBuilder(vectorBuckets);
        }

        @Override
        public final Builder vectorBuckets(Collection<VectorBucketSummary> vectorBuckets) {
            this.vectorBuckets = ListVectorBucketsOutputListCopier.copy(vectorBuckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectorBuckets(VectorBucketSummary ... vectorBuckets) {
            this.vectorBuckets(Arrays.asList(vectorBuckets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vectorBuckets(Consumer<VectorBucketSummary.Builder> ... vectorBuckets) {
            this.vectorBuckets(Stream.of(vectorBuckets).map(c -> (VectorBucketSummary)((VectorBucketSummary.Builder)VectorBucketSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVectorBucketsResponse build() {
            return new ListVectorBucketsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3VectorsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVectorBucketsResponse> {
        public Builder nextToken(String var1);

        public Builder vectorBuckets(Collection<VectorBucketSummary> var1);

        public Builder vectorBuckets(VectorBucketSummary ... var1);

        public Builder vectorBuckets(Consumer<VectorBucketSummary.Builder> ... var1);
    }
}

