/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListOptimizationJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListOptimizationJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.OptimizationJobSummary;

public class ListOptimizationJobsPublisher
implements SdkPublisher<ListOptimizationJobsResponse> {
    private final SageMakerAsyncClient client;
    private final ListOptimizationJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOptimizationJobsPublisher(SageMakerAsyncClient client, ListOptimizationJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOptimizationJobsPublisher(SageMakerAsyncClient client, ListOptimizationJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOptimizationJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOptimizationJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OptimizationJobSummary> optimizationJobSummaries() {
        Function<ListOptimizationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.optimizationJobSummaries() != null) {
                return response.optimizationJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOptimizationJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOptimizationJobsResponseFetcher
    implements AsyncPageFetcher<ListOptimizationJobsResponse> {
        private ListOptimizationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListOptimizationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOptimizationJobsResponse> nextPage(ListOptimizationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListOptimizationJobsPublisher.this.client.listOptimizationJobs(ListOptimizationJobsPublisher.this.firstRequest);
            }
            return ListOptimizationJobsPublisher.this.client.listOptimizationJobs((ListOptimizationJobsRequest)((Object)ListOptimizationJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

