/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingJobStatusCounters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingJobStatusCounters> {
    private static final SdkField<Integer> COMPLETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Completed").getter(TrainingJobStatusCounters.getter(TrainingJobStatusCounters::completed)).setter(TrainingJobStatusCounters.setter(Builder::completed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Completed").build()}).build();
    private static final SdkField<Integer> IN_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InProgress").getter(TrainingJobStatusCounters.getter(TrainingJobStatusCounters::inProgress)).setter(TrainingJobStatusCounters.setter(Builder::inProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InProgress").build()}).build();
    private static final SdkField<Integer> RETRYABLE_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetryableError").getter(TrainingJobStatusCounters.getter(TrainingJobStatusCounters::retryableError)).setter(TrainingJobStatusCounters.setter(Builder::retryableError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryableError").build()}).build();
    private static final SdkField<Integer> NON_RETRYABLE_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NonRetryableError").getter(TrainingJobStatusCounters.getter(TrainingJobStatusCounters::nonRetryableError)).setter(TrainingJobStatusCounters.setter(Builder::nonRetryableError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonRetryableError").build()}).build();
    private static final SdkField<Integer> STOPPED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Stopped").getter(TrainingJobStatusCounters.getter(TrainingJobStatusCounters::stopped)).setter(TrainingJobStatusCounters.setter(Builder::stopped)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stopped").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETED_FIELD, IN_PROGRESS_FIELD, RETRYABLE_ERROR_FIELD, NON_RETRYABLE_ERROR_FIELD, STOPPED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrainingJobStatusCounters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer completed;
    private final Integer inProgress;
    private final Integer retryableError;
    private final Integer nonRetryableError;
    private final Integer stopped;

    private TrainingJobStatusCounters(BuilderImpl builder) {
        this.completed = builder.completed;
        this.inProgress = builder.inProgress;
        this.retryableError = builder.retryableError;
        this.nonRetryableError = builder.nonRetryableError;
        this.stopped = builder.stopped;
    }

    public final Integer completed() {
        return this.completed;
    }

    public final Integer inProgress() {
        return this.inProgress;
    }

    public final Integer retryableError() {
        return this.retryableError;
    }

    public final Integer nonRetryableError() {
        return this.nonRetryableError;
    }

    public final Integer stopped() {
        return this.stopped;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.completed());
        hashCode = 31 * hashCode + Objects.hashCode(this.inProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryableError());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonRetryableError());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopped());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingJobStatusCounters)) {
            return false;
        }
        TrainingJobStatusCounters other = (TrainingJobStatusCounters)obj;
        return Objects.equals(this.completed(), other.completed()) && Objects.equals(this.inProgress(), other.inProgress()) && Objects.equals(this.retryableError(), other.retryableError()) && Objects.equals(this.nonRetryableError(), other.nonRetryableError()) && Objects.equals(this.stopped(), other.stopped());
    }

    public final String toString() {
        return ToString.builder((String)"TrainingJobStatusCounters").add("Completed", (Object)this.completed()).add("InProgress", (Object)this.inProgress()).add("RetryableError", (Object)this.retryableError()).add("NonRetryableError", (Object)this.nonRetryableError()).add("Stopped", (Object)this.stopped()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Completed": {
                return Optional.ofNullable(clazz.cast(this.completed()));
            }
            case "InProgress": {
                return Optional.ofNullable(clazz.cast(this.inProgress()));
            }
            case "RetryableError": {
                return Optional.ofNullable(clazz.cast(this.retryableError()));
            }
            case "NonRetryableError": {
                return Optional.ofNullable(clazz.cast(this.nonRetryableError()));
            }
            case "Stopped": {
                return Optional.ofNullable(clazz.cast(this.stopped()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("Completed", COMPLETED_FIELD);
        map.put("InProgress", IN_PROGRESS_FIELD);
        map.put("RetryableError", RETRYABLE_ERROR_FIELD);
        map.put("NonRetryableError", NON_RETRYABLE_ERROR_FIELD);
        map.put("Stopped", STOPPED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainingJobStatusCounters, T> g) {
        return obj -> g.apply((TrainingJobStatusCounters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer completed;
        private Integer inProgress;
        private Integer retryableError;
        private Integer nonRetryableError;
        private Integer stopped;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingJobStatusCounters model) {
            this.completed(model.completed);
            this.inProgress(model.inProgress);
            this.retryableError(model.retryableError);
            this.nonRetryableError(model.nonRetryableError);
            this.stopped(model.stopped);
        }

        public final Integer getCompleted() {
            return this.completed;
        }

        public final void setCompleted(Integer completed) {
            this.completed = completed;
        }

        @Override
        public final Builder completed(Integer completed) {
            this.completed = completed;
            return this;
        }

        public final Integer getInProgress() {
            return this.inProgress;
        }

        public final void setInProgress(Integer inProgress) {
            this.inProgress = inProgress;
        }

        @Override
        public final Builder inProgress(Integer inProgress) {
            this.inProgress = inProgress;
            return this;
        }

        public final Integer getRetryableError() {
            return this.retryableError;
        }

        public final void setRetryableError(Integer retryableError) {
            this.retryableError = retryableError;
        }

        @Override
        public final Builder retryableError(Integer retryableError) {
            this.retryableError = retryableError;
            return this;
        }

        public final Integer getNonRetryableError() {
            return this.nonRetryableError;
        }

        public final void setNonRetryableError(Integer nonRetryableError) {
            this.nonRetryableError = nonRetryableError;
        }

        @Override
        public final Builder nonRetryableError(Integer nonRetryableError) {
            this.nonRetryableError = nonRetryableError;
            return this;
        }

        public final Integer getStopped() {
            return this.stopped;
        }

        public final void setStopped(Integer stopped) {
            this.stopped = stopped;
        }

        @Override
        public final Builder stopped(Integer stopped) {
            this.stopped = stopped;
            return this;
        }

        public TrainingJobStatusCounters build() {
            return new TrainingJobStatusCounters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingJobStatusCounters> {
        public Builder completed(Integer var1);

        public Builder inProgress(Integer var1);

        public Builder retryableError(Integer var1);

        public Builder nonRetryableError(Integer var1);

        public Builder stopped(Integer var1);
    }
}

