/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ReservedCapacityInstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UltraServerSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UltraServerSummary> {
    private static final SdkField<String> ULTRA_SERVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UltraServerType").getter(UltraServerSummary.getter(UltraServerSummary::ultraServerType)).setter(UltraServerSummary.setter(Builder::ultraServerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UltraServerType").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(UltraServerSummary.getter(UltraServerSummary::instanceTypeAsString)).setter(UltraServerSummary.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Integer> ULTRA_SERVER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UltraServerCount").getter(UltraServerSummary.getter(UltraServerSummary::ultraServerCount)).setter(UltraServerSummary.setter(Builder::ultraServerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UltraServerCount").build()}).build();
    private static final SdkField<Integer> AVAILABLE_SPARE_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableSpareInstanceCount").getter(UltraServerSummary.getter(UltraServerSummary::availableSpareInstanceCount)).setter(UltraServerSummary.setter(Builder::availableSpareInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableSpareInstanceCount").build()}).build();
    private static final SdkField<Integer> UNHEALTHY_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UnhealthyInstanceCount").getter(UltraServerSummary.getter(UltraServerSummary::unhealthyInstanceCount)).setter(UltraServerSummary.setter(Builder::unhealthyInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnhealthyInstanceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ULTRA_SERVER_TYPE_FIELD, INSTANCE_TYPE_FIELD, ULTRA_SERVER_COUNT_FIELD, AVAILABLE_SPARE_INSTANCE_COUNT_FIELD, UNHEALTHY_INSTANCE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UltraServerSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ultraServerType;
    private final String instanceType;
    private final Integer ultraServerCount;
    private final Integer availableSpareInstanceCount;
    private final Integer unhealthyInstanceCount;

    private UltraServerSummary(BuilderImpl builder) {
        this.ultraServerType = builder.ultraServerType;
        this.instanceType = builder.instanceType;
        this.ultraServerCount = builder.ultraServerCount;
        this.availableSpareInstanceCount = builder.availableSpareInstanceCount;
        this.unhealthyInstanceCount = builder.unhealthyInstanceCount;
    }

    public final String ultraServerType() {
        return this.ultraServerType;
    }

    public final ReservedCapacityInstanceType instanceType() {
        return ReservedCapacityInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Integer ultraServerCount() {
        return this.ultraServerCount;
    }

    public final Integer availableSpareInstanceCount() {
        return this.availableSpareInstanceCount;
    }

    public final Integer unhealthyInstanceCount() {
        return this.unhealthyInstanceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ultraServerType());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ultraServerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableSpareInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.unhealthyInstanceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UltraServerSummary)) {
            return false;
        }
        UltraServerSummary other = (UltraServerSummary)obj;
        return Objects.equals(this.ultraServerType(), other.ultraServerType()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.ultraServerCount(), other.ultraServerCount()) && Objects.equals(this.availableSpareInstanceCount(), other.availableSpareInstanceCount()) && Objects.equals(this.unhealthyInstanceCount(), other.unhealthyInstanceCount());
    }

    public final String toString() {
        return ToString.builder((String)"UltraServerSummary").add("UltraServerType", (Object)this.ultraServerType()).add("InstanceType", (Object)this.instanceTypeAsString()).add("UltraServerCount", (Object)this.ultraServerCount()).add("AvailableSpareInstanceCount", (Object)this.availableSpareInstanceCount()).add("UnhealthyInstanceCount", (Object)this.unhealthyInstanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UltraServerType": {
                return Optional.ofNullable(clazz.cast(this.ultraServerType()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "UltraServerCount": {
                return Optional.ofNullable(clazz.cast(this.ultraServerCount()));
            }
            case "AvailableSpareInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.availableSpareInstanceCount()));
            }
            case "UnhealthyInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.unhealthyInstanceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UltraServerType", ULTRA_SERVER_TYPE_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("UltraServerCount", ULTRA_SERVER_COUNT_FIELD);
        map.put("AvailableSpareInstanceCount", AVAILABLE_SPARE_INSTANCE_COUNT_FIELD);
        map.put("UnhealthyInstanceCount", UNHEALTHY_INSTANCE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UltraServerSummary, T> g) {
        return obj -> g.apply((UltraServerSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ultraServerType;
        private String instanceType;
        private Integer ultraServerCount;
        private Integer availableSpareInstanceCount;
        private Integer unhealthyInstanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(UltraServerSummary model) {
            this.ultraServerType(model.ultraServerType);
            this.instanceType(model.instanceType);
            this.ultraServerCount(model.ultraServerCount);
            this.availableSpareInstanceCount(model.availableSpareInstanceCount);
            this.unhealthyInstanceCount(model.unhealthyInstanceCount);
        }

        public final String getUltraServerType() {
            return this.ultraServerType;
        }

        public final void setUltraServerType(String ultraServerType) {
            this.ultraServerType = ultraServerType;
        }

        @Override
        public final Builder ultraServerType(String ultraServerType) {
            this.ultraServerType = ultraServerType;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ReservedCapacityInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getUltraServerCount() {
            return this.ultraServerCount;
        }

        public final void setUltraServerCount(Integer ultraServerCount) {
            this.ultraServerCount = ultraServerCount;
        }

        @Override
        public final Builder ultraServerCount(Integer ultraServerCount) {
            this.ultraServerCount = ultraServerCount;
            return this;
        }

        public final Integer getAvailableSpareInstanceCount() {
            return this.availableSpareInstanceCount;
        }

        public final void setAvailableSpareInstanceCount(Integer availableSpareInstanceCount) {
            this.availableSpareInstanceCount = availableSpareInstanceCount;
        }

        @Override
        public final Builder availableSpareInstanceCount(Integer availableSpareInstanceCount) {
            this.availableSpareInstanceCount = availableSpareInstanceCount;
            return this;
        }

        public final Integer getUnhealthyInstanceCount() {
            return this.unhealthyInstanceCount;
        }

        public final void setUnhealthyInstanceCount(Integer unhealthyInstanceCount) {
            this.unhealthyInstanceCount = unhealthyInstanceCount;
        }

        @Override
        public final Builder unhealthyInstanceCount(Integer unhealthyInstanceCount) {
            this.unhealthyInstanceCount = unhealthyInstanceCount;
            return this;
        }

        public UltraServerSummary build() {
            return new UltraServerSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UltraServerSummary> {
        public Builder ultraServerType(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(ReservedCapacityInstanceType var1);

        public Builder ultraServerCount(Integer var1);

        public Builder availableSpareInstanceCount(Integer var1);

        public Builder unhealthyInstanceCount(Integer var1);
    }
}

