/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ClusterAutoScalingConfig;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupSpecification;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupSpecificationsCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterNodeProvisioningMode;
import software.amazon.awssdk.services.sagemaker.model.ClusterNodeRecovery;
import software.amazon.awssdk.services.sagemaker.model.ClusterOrchestrator;
import software.amazon.awssdk.services.sagemaker.model.ClusterRestrictedInstanceGroupSpecification;
import software.amazon.awssdk.services.sagemaker.model.ClusterRestrictedInstanceGroupSpecificationsCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterTieredStorageConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClusterRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateClusterRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(CreateClusterRequest.getter(CreateClusterRequest::clusterName)).setter(CreateClusterRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<List<ClusterInstanceGroupSpecification>> INSTANCE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceGroups").getter(CreateClusterRequest.getter(CreateClusterRequest::instanceGroups)).setter(CreateClusterRequest.setter(Builder::instanceGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterInstanceGroupSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ClusterRestrictedInstanceGroupSpecification>> RESTRICTED_INSTANCE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RestrictedInstanceGroups").getter(CreateClusterRequest.getter(CreateClusterRequest::restrictedInstanceGroups)).setter(CreateClusterRequest.setter(Builder::restrictedInstanceGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestrictedInstanceGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterRestrictedInstanceGroupSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(CreateClusterRequest.getter(CreateClusterRequest::vpcConfig)).setter(CreateClusterRequest.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateClusterRequest.getter(CreateClusterRequest::tags)).setter(CreateClusterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ClusterOrchestrator> ORCHESTRATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Orchestrator").getter(CreateClusterRequest.getter(CreateClusterRequest::orchestrator)).setter(CreateClusterRequest.setter(Builder::orchestrator)).constructor(ClusterOrchestrator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Orchestrator").build()}).build();
    private static final SdkField<String> NODE_RECOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeRecovery").getter(CreateClusterRequest.getter(CreateClusterRequest::nodeRecoveryAsString)).setter(CreateClusterRequest.setter(Builder::nodeRecovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeRecovery").build()}).build();
    private static final SdkField<ClusterTieredStorageConfig> TIERED_STORAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TieredStorageConfig").getter(CreateClusterRequest.getter(CreateClusterRequest::tieredStorageConfig)).setter(CreateClusterRequest.setter(Builder::tieredStorageConfig)).constructor(ClusterTieredStorageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieredStorageConfig").build()}).build();
    private static final SdkField<String> NODE_PROVISIONING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeProvisioningMode").getter(CreateClusterRequest.getter(CreateClusterRequest::nodeProvisioningModeAsString)).setter(CreateClusterRequest.setter(Builder::nodeProvisioningMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeProvisioningMode").build()}).build();
    private static final SdkField<String> CLUSTER_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterRole").getter(CreateClusterRequest.getter(CreateClusterRequest::clusterRole)).setter(CreateClusterRequest.setter(Builder::clusterRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterRole").build()}).build();
    private static final SdkField<ClusterAutoScalingConfig> AUTO_SCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoScaling").getter(CreateClusterRequest.getter(CreateClusterRequest::autoScaling)).setter(CreateClusterRequest.setter(Builder::autoScaling)).constructor(ClusterAutoScalingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScaling").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, INSTANCE_GROUPS_FIELD, RESTRICTED_INSTANCE_GROUPS_FIELD, VPC_CONFIG_FIELD, TAGS_FIELD, ORCHESTRATOR_FIELD, NODE_RECOVERY_FIELD, TIERED_STORAGE_CONFIG_FIELD, NODE_PROVISIONING_MODE_FIELD, CLUSTER_ROLE_FIELD, AUTO_SCALING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateClusterRequest.memberNameToFieldInitializer();
    private final String clusterName;
    private final List<ClusterInstanceGroupSpecification> instanceGroups;
    private final List<ClusterRestrictedInstanceGroupSpecification> restrictedInstanceGroups;
    private final VpcConfig vpcConfig;
    private final List<Tag> tags;
    private final ClusterOrchestrator orchestrator;
    private final String nodeRecovery;
    private final ClusterTieredStorageConfig tieredStorageConfig;
    private final String nodeProvisioningMode;
    private final String clusterRole;
    private final ClusterAutoScalingConfig autoScaling;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.instanceGroups = builder.instanceGroups;
        this.restrictedInstanceGroups = builder.restrictedInstanceGroups;
        this.vpcConfig = builder.vpcConfig;
        this.tags = builder.tags;
        this.orchestrator = builder.orchestrator;
        this.nodeRecovery = builder.nodeRecovery;
        this.tieredStorageConfig = builder.tieredStorageConfig;
        this.nodeProvisioningMode = builder.nodeProvisioningMode;
        this.clusterRole = builder.clusterRole;
        this.autoScaling = builder.autoScaling;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final boolean hasInstanceGroups() {
        return this.instanceGroups != null && !(this.instanceGroups instanceof SdkAutoConstructList);
    }

    public final List<ClusterInstanceGroupSpecification> instanceGroups() {
        return this.instanceGroups;
    }

    public final boolean hasRestrictedInstanceGroups() {
        return this.restrictedInstanceGroups != null && !(this.restrictedInstanceGroups instanceof SdkAutoConstructList);
    }

    public final List<ClusterRestrictedInstanceGroupSpecification> restrictedInstanceGroups() {
        return this.restrictedInstanceGroups;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ClusterOrchestrator orchestrator() {
        return this.orchestrator;
    }

    public final ClusterNodeRecovery nodeRecovery() {
        return ClusterNodeRecovery.fromValue(this.nodeRecovery);
    }

    public final String nodeRecoveryAsString() {
        return this.nodeRecovery;
    }

    public final ClusterTieredStorageConfig tieredStorageConfig() {
        return this.tieredStorageConfig;
    }

    public final ClusterNodeProvisioningMode nodeProvisioningMode() {
        return ClusterNodeProvisioningMode.fromValue(this.nodeProvisioningMode);
    }

    public final String nodeProvisioningModeAsString() {
        return this.nodeProvisioningMode;
    }

    public final String clusterRole() {
        return this.clusterRole;
    }

    public final ClusterAutoScalingConfig autoScaling() {
        return this.autoScaling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceGroups() ? this.instanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRestrictedInstanceGroups() ? this.restrictedInstanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.orchestrator());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeRecoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tieredStorageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeProvisioningModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScaling());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && this.hasInstanceGroups() == other.hasInstanceGroups() && Objects.equals(this.instanceGroups(), other.instanceGroups()) && this.hasRestrictedInstanceGroups() == other.hasRestrictedInstanceGroups() && Objects.equals(this.restrictedInstanceGroups(), other.restrictedInstanceGroups()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.orchestrator(), other.orchestrator()) && Objects.equals(this.nodeRecoveryAsString(), other.nodeRecoveryAsString()) && Objects.equals(this.tieredStorageConfig(), other.tieredStorageConfig()) && Objects.equals(this.nodeProvisioningModeAsString(), other.nodeProvisioningModeAsString()) && Objects.equals(this.clusterRole(), other.clusterRole()) && Objects.equals(this.autoScaling(), other.autoScaling());
    }

    public final String toString() {
        return ToString.builder((String)"CreateClusterRequest").add("ClusterName", (Object)this.clusterName()).add("InstanceGroups", this.hasInstanceGroups() ? this.instanceGroups() : null).add("RestrictedInstanceGroups", this.hasRestrictedInstanceGroups() ? this.restrictedInstanceGroups() : null).add("VpcConfig", (Object)this.vpcConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("Orchestrator", (Object)this.orchestrator()).add("NodeRecovery", (Object)this.nodeRecoveryAsString()).add("TieredStorageConfig", (Object)this.tieredStorageConfig()).add("NodeProvisioningMode", (Object)this.nodeProvisioningModeAsString()).add("ClusterRole", (Object)this.clusterRole()).add("AutoScaling", (Object)this.autoScaling()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "InstanceGroups": {
                return Optional.ofNullable(clazz.cast(this.instanceGroups()));
            }
            case "RestrictedInstanceGroups": {
                return Optional.ofNullable(clazz.cast(this.restrictedInstanceGroups()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Orchestrator": {
                return Optional.ofNullable(clazz.cast(this.orchestrator()));
            }
            case "NodeRecovery": {
                return Optional.ofNullable(clazz.cast(this.nodeRecoveryAsString()));
            }
            case "TieredStorageConfig": {
                return Optional.ofNullable(clazz.cast(this.tieredStorageConfig()));
            }
            case "NodeProvisioningMode": {
                return Optional.ofNullable(clazz.cast(this.nodeProvisioningModeAsString()));
            }
            case "ClusterRole": {
                return Optional.ofNullable(clazz.cast(this.clusterRole()));
            }
            case "AutoScaling": {
                return Optional.ofNullable(clazz.cast(this.autoScaling()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("InstanceGroups", INSTANCE_GROUPS_FIELD);
        map.put("RestrictedInstanceGroups", RESTRICTED_INSTANCE_GROUPS_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Orchestrator", ORCHESTRATOR_FIELD);
        map.put("NodeRecovery", NODE_RECOVERY_FIELD);
        map.put("TieredStorageConfig", TIERED_STORAGE_CONFIG_FIELD);
        map.put("NodeProvisioningMode", NODE_PROVISIONING_MODE_FIELD);
        map.put("ClusterRole", CLUSTER_ROLE_FIELD);
        map.put("AutoScaling", AUTO_SCALING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private List<ClusterInstanceGroupSpecification> instanceGroups = DefaultSdkAutoConstructList.getInstance();
        private List<ClusterRestrictedInstanceGroupSpecification> restrictedInstanceGroups = DefaultSdkAutoConstructList.getInstance();
        private VpcConfig vpcConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private ClusterOrchestrator orchestrator;
        private String nodeRecovery;
        private ClusterTieredStorageConfig tieredStorageConfig;
        private String nodeProvisioningMode;
        private String clusterRole;
        private ClusterAutoScalingConfig autoScaling;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.instanceGroups(model.instanceGroups);
            this.restrictedInstanceGroups(model.restrictedInstanceGroups);
            this.vpcConfig(model.vpcConfig);
            this.tags(model.tags);
            this.orchestrator(model.orchestrator);
            this.nodeRecovery(model.nodeRecovery);
            this.tieredStorageConfig(model.tieredStorageConfig);
            this.nodeProvisioningMode(model.nodeProvisioningMode);
            this.clusterRole(model.clusterRole);
            this.autoScaling(model.autoScaling);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final List<ClusterInstanceGroupSpecification.Builder> getInstanceGroups() {
            List<ClusterInstanceGroupSpecification.Builder> result = ClusterInstanceGroupSpecificationsCopier.copyToBuilder(this.instanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceGroups(Collection<ClusterInstanceGroupSpecification.BuilderImpl> instanceGroups) {
            this.instanceGroups = ClusterInstanceGroupSpecificationsCopier.copyFromBuilder(instanceGroups);
        }

        @Override
        public final Builder instanceGroups(Collection<ClusterInstanceGroupSpecification> instanceGroups) {
            this.instanceGroups = ClusterInstanceGroupSpecificationsCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(ClusterInstanceGroupSpecification ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<ClusterInstanceGroupSpecification.Builder> ... instanceGroups) {
            this.instanceGroups(Stream.of(instanceGroups).map(c -> (ClusterInstanceGroupSpecification)((ClusterInstanceGroupSpecification.Builder)ClusterInstanceGroupSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ClusterRestrictedInstanceGroupSpecification.Builder> getRestrictedInstanceGroups() {
            List<ClusterRestrictedInstanceGroupSpecification.Builder> result = ClusterRestrictedInstanceGroupSpecificationsCopier.copyToBuilder(this.restrictedInstanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRestrictedInstanceGroups(Collection<ClusterRestrictedInstanceGroupSpecification.BuilderImpl> restrictedInstanceGroups) {
            this.restrictedInstanceGroups = ClusterRestrictedInstanceGroupSpecificationsCopier.copyFromBuilder(restrictedInstanceGroups);
        }

        @Override
        public final Builder restrictedInstanceGroups(Collection<ClusterRestrictedInstanceGroupSpecification> restrictedInstanceGroups) {
            this.restrictedInstanceGroups = ClusterRestrictedInstanceGroupSpecificationsCopier.copy(restrictedInstanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restrictedInstanceGroups(ClusterRestrictedInstanceGroupSpecification ... restrictedInstanceGroups) {
            this.restrictedInstanceGroups(Arrays.asList(restrictedInstanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restrictedInstanceGroups(Consumer<ClusterRestrictedInstanceGroupSpecification.Builder> ... restrictedInstanceGroups) {
            this.restrictedInstanceGroups(Stream.of(restrictedInstanceGroups).map(c -> (ClusterRestrictedInstanceGroupSpecification)((ClusterRestrictedInstanceGroupSpecification.Builder)ClusterRestrictedInstanceGroupSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ClusterOrchestrator.Builder getOrchestrator() {
            return this.orchestrator != null ? this.orchestrator.toBuilder() : null;
        }

        public final void setOrchestrator(ClusterOrchestrator.BuilderImpl orchestrator) {
            this.orchestrator = orchestrator != null ? orchestrator.build() : null;
        }

        @Override
        public final Builder orchestrator(ClusterOrchestrator orchestrator) {
            this.orchestrator = orchestrator;
            return this;
        }

        public final String getNodeRecovery() {
            return this.nodeRecovery;
        }

        public final void setNodeRecovery(String nodeRecovery) {
            this.nodeRecovery = nodeRecovery;
        }

        @Override
        public final Builder nodeRecovery(String nodeRecovery) {
            this.nodeRecovery = nodeRecovery;
            return this;
        }

        @Override
        public final Builder nodeRecovery(ClusterNodeRecovery nodeRecovery) {
            this.nodeRecovery(nodeRecovery == null ? null : nodeRecovery.toString());
            return this;
        }

        public final ClusterTieredStorageConfig.Builder getTieredStorageConfig() {
            return this.tieredStorageConfig != null ? this.tieredStorageConfig.toBuilder() : null;
        }

        public final void setTieredStorageConfig(ClusterTieredStorageConfig.BuilderImpl tieredStorageConfig) {
            this.tieredStorageConfig = tieredStorageConfig != null ? tieredStorageConfig.build() : null;
        }

        @Override
        public final Builder tieredStorageConfig(ClusterTieredStorageConfig tieredStorageConfig) {
            this.tieredStorageConfig = tieredStorageConfig;
            return this;
        }

        public final String getNodeProvisioningMode() {
            return this.nodeProvisioningMode;
        }

        public final void setNodeProvisioningMode(String nodeProvisioningMode) {
            this.nodeProvisioningMode = nodeProvisioningMode;
        }

        @Override
        public final Builder nodeProvisioningMode(String nodeProvisioningMode) {
            this.nodeProvisioningMode = nodeProvisioningMode;
            return this;
        }

        @Override
        public final Builder nodeProvisioningMode(ClusterNodeProvisioningMode nodeProvisioningMode) {
            this.nodeProvisioningMode(nodeProvisioningMode == null ? null : nodeProvisioningMode.toString());
            return this;
        }

        public final String getClusterRole() {
            return this.clusterRole;
        }

        public final void setClusterRole(String clusterRole) {
            this.clusterRole = clusterRole;
        }

        @Override
        public final Builder clusterRole(String clusterRole) {
            this.clusterRole = clusterRole;
            return this;
        }

        public final ClusterAutoScalingConfig.Builder getAutoScaling() {
            return this.autoScaling != null ? this.autoScaling.toBuilder() : null;
        }

        public final void setAutoScaling(ClusterAutoScalingConfig.BuilderImpl autoScaling) {
            this.autoScaling = autoScaling != null ? autoScaling.build() : null;
        }

        @Override
        public final Builder autoScaling(ClusterAutoScalingConfig autoScaling) {
            this.autoScaling = autoScaling;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClusterRequest> {
        public Builder clusterName(String var1);

        public Builder instanceGroups(Collection<ClusterInstanceGroupSpecification> var1);

        public Builder instanceGroups(ClusterInstanceGroupSpecification ... var1);

        public Builder instanceGroups(Consumer<ClusterInstanceGroupSpecification.Builder> ... var1);

        public Builder restrictedInstanceGroups(Collection<ClusterRestrictedInstanceGroupSpecification> var1);

        public Builder restrictedInstanceGroups(ClusterRestrictedInstanceGroupSpecification ... var1);

        public Builder restrictedInstanceGroups(Consumer<ClusterRestrictedInstanceGroupSpecification.Builder> ... var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder orchestrator(ClusterOrchestrator var1);

        default public Builder orchestrator(Consumer<ClusterOrchestrator.Builder> orchestrator) {
            return this.orchestrator((ClusterOrchestrator)((ClusterOrchestrator.Builder)ClusterOrchestrator.builder().applyMutation(orchestrator)).build());
        }

        public Builder nodeRecovery(String var1);

        public Builder nodeRecovery(ClusterNodeRecovery var1);

        public Builder tieredStorageConfig(ClusterTieredStorageConfig var1);

        default public Builder tieredStorageConfig(Consumer<ClusterTieredStorageConfig.Builder> tieredStorageConfig) {
            return this.tieredStorageConfig((ClusterTieredStorageConfig)((ClusterTieredStorageConfig.Builder)ClusterTieredStorageConfig.builder().applyMutation(tieredStorageConfig)).build());
        }

        public Builder nodeProvisioningMode(String var1);

        public Builder nodeProvisioningMode(ClusterNodeProvisioningMode var1);

        public Builder clusterRole(String var1);

        public Builder autoScaling(ClusterAutoScalingConfig var1);

        default public Builder autoScaling(Consumer<ClusterAutoScalingConfig.Builder> autoScaling) {
            return this.autoScaling((ClusterAutoScalingConfig)((ClusterAutoScalingConfig.Builder)ClusterAutoScalingConfig.builder().applyMutation(autoScaling)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

