/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeAdditionResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeAdditionResult> {
    private static final SdkField<String> NODE_LOGICAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeLogicalId").getter(NodeAdditionResult.getter(NodeAdditionResult::nodeLogicalId)).setter(NodeAdditionResult.setter(Builder::nodeLogicalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeLogicalId").build()}).build();
    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceGroupName").getter(NodeAdditionResult.getter(NodeAdditionResult::instanceGroupName)).setter(NodeAdditionResult.setter(Builder::instanceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(NodeAdditionResult.getter(NodeAdditionResult::statusAsString)).setter(NodeAdditionResult.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_LOGICAL_ID_FIELD, INSTANCE_GROUP_NAME_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NodeAdditionResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String nodeLogicalId;
    private final String instanceGroupName;
    private final String status;

    private NodeAdditionResult(BuilderImpl builder) {
        this.nodeLogicalId = builder.nodeLogicalId;
        this.instanceGroupName = builder.instanceGroupName;
        this.status = builder.status;
    }

    public final String nodeLogicalId() {
        return this.nodeLogicalId;
    }

    public final String instanceGroupName() {
        return this.instanceGroupName;
    }

    public final ClusterInstanceStatus status() {
        return ClusterInstanceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeLogicalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeAdditionResult)) {
            return false;
        }
        NodeAdditionResult other = (NodeAdditionResult)obj;
        return Objects.equals(this.nodeLogicalId(), other.nodeLogicalId()) && Objects.equals(this.instanceGroupName(), other.instanceGroupName()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NodeAdditionResult").add("NodeLogicalId", (Object)this.nodeLogicalId()).add("InstanceGroupName", (Object)this.instanceGroupName()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeLogicalId": {
                return Optional.ofNullable(clazz.cast(this.nodeLogicalId()));
            }
            case "InstanceGroupName": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("NodeLogicalId", NODE_LOGICAL_ID_FIELD);
        map.put("InstanceGroupName", INSTANCE_GROUP_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeAdditionResult, T> g) {
        return obj -> g.apply((NodeAdditionResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeLogicalId;
        private String instanceGroupName;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeAdditionResult model) {
            this.nodeLogicalId(model.nodeLogicalId);
            this.instanceGroupName(model.instanceGroupName);
            this.status(model.status);
        }

        public final String getNodeLogicalId() {
            return this.nodeLogicalId;
        }

        public final void setNodeLogicalId(String nodeLogicalId) {
            this.nodeLogicalId = nodeLogicalId;
        }

        @Override
        public final Builder nodeLogicalId(String nodeLogicalId) {
            this.nodeLogicalId = nodeLogicalId;
            return this;
        }

        public final String getInstanceGroupName() {
            return this.instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClusterInstanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public NodeAdditionResult build() {
            return new NodeAdditionResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeAdditionResult> {
        public Builder nodeLogicalId(String var1);

        public Builder instanceGroupName(String var1);

        public Builder status(String var1);

        public Builder status(ClusterInstanceStatus var1);
    }
}

