/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineVersionsResponse;
import software.amazon.awssdk.services.sagemaker.model.PipelineVersionSummary;

public class ListPipelineVersionsIterable
implements SdkIterable<ListPipelineVersionsResponse> {
    private final SageMakerClient client;
    private final ListPipelineVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPipelineVersionsIterable(SageMakerClient client, ListPipelineVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPipelineVersionsResponseFetcher();
    }

    public Iterator<ListPipelineVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PipelineVersionSummary> pipelineVersionSummaries() {
        Function<ListPipelineVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineVersionSummaries() != null) {
                return response.pipelineVersionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPipelineVersionsResponseFetcher
    implements SyncPageFetcher<ListPipelineVersionsResponse> {
        private ListPipelineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelineVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPipelineVersionsResponse nextPage(ListPipelineVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListPipelineVersionsIterable.this.client.listPipelineVersions(ListPipelineVersionsIterable.this.firstRequest);
            }
            return ListPipelineVersionsIterable.this.client.listPipelineVersions((ListPipelineVersionsRequest)((Object)ListPipelineVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

