/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.CfnStackCreateParameter;
import software.amazon.awssdk.services.sagemaker.model.CfnStackCreateParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CfnCreateTemplateProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CfnCreateTemplateProvider> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(CfnCreateTemplateProvider.getter(CfnCreateTemplateProvider::templateName)).setter(CfnCreateTemplateProvider.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateURL").getter(CfnCreateTemplateProvider.getter(CfnCreateTemplateProvider::templateURL)).setter(CfnCreateTemplateProvider.setter(Builder::templateURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateURL").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(CfnCreateTemplateProvider.getter(CfnCreateTemplateProvider::roleARN)).setter(CfnCreateTemplateProvider.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<List<CfnStackCreateParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(CfnCreateTemplateProvider.getter(CfnCreateTemplateProvider::parameters)).setter(CfnCreateTemplateProvider.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CfnStackCreateParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, TEMPLATE_URL_FIELD, ROLE_ARN_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CfnCreateTemplateProvider.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String templateName;
    private final String templateURL;
    private final String roleARN;
    private final List<CfnStackCreateParameter> parameters;

    private CfnCreateTemplateProvider(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.templateURL = builder.templateURL;
        this.roleARN = builder.roleARN;
        this.parameters = builder.parameters;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String templateURL() {
        return this.templateURL;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<CfnStackCreateParameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CfnCreateTemplateProvider)) {
            return false;
        }
        CfnCreateTemplateProvider other = (CfnCreateTemplateProvider)obj;
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.templateURL(), other.templateURL()) && Objects.equals(this.roleARN(), other.roleARN()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"CfnCreateTemplateProvider").add("TemplateName", (Object)this.templateName()).add("TemplateURL", (Object)this.templateURL()).add("RoleARN", (Object)this.roleARN()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "TemplateURL": {
                return Optional.ofNullable(clazz.cast(this.templateURL()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TemplateName", TEMPLATE_NAME_FIELD);
        map.put("TemplateURL", TEMPLATE_URL_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CfnCreateTemplateProvider, T> g) {
        return obj -> g.apply((CfnCreateTemplateProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String templateName;
        private String templateURL;
        private String roleARN;
        private List<CfnStackCreateParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CfnCreateTemplateProvider model) {
            this.templateName(model.templateName);
            this.templateURL(model.templateURL);
            this.roleARN(model.roleARN);
            this.parameters(model.parameters);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateURL() {
            return this.templateURL;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final List<CfnStackCreateParameter.Builder> getParameters() {
            List<CfnStackCreateParameter.Builder> result = CfnStackCreateParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<CfnStackCreateParameter.BuilderImpl> parameters) {
            this.parameters = CfnStackCreateParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<CfnStackCreateParameter> parameters) {
            this.parameters = CfnStackCreateParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(CfnStackCreateParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<CfnStackCreateParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (CfnStackCreateParameter)((CfnStackCreateParameter.Builder)CfnStackCreateParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CfnCreateTemplateProvider build() {
            return new CfnCreateTemplateProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CfnCreateTemplateProvider> {
        public Builder templateName(String var1);

        public Builder templateURL(String var1);

        public Builder roleARN(String var1);

        public Builder parameters(Collection<CfnStackCreateParameter> var1);

        public Builder parameters(CfnStackCreateParameter ... var1);

        public Builder parameters(Consumer<CfnStackCreateParameter.Builder> ... var1);
    }
}

