/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HubContentStatus {
    AVAILABLE("Available"),
    IMPORTING("Importing"),
    DELETING("Deleting"),
    IMPORT_FAILED("ImportFailed"),
    DELETE_FAILED("DeleteFailed"),
    PENDING_IMPORT("PendingImport"),
    PENDING_DELETE("PendingDelete"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HubContentStatus> VALUE_MAP;
    private final String value;

    private HubContentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HubContentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HubContentStatus> knownValues() {
        EnumSet<HubContentStatus> knownValues = EnumSet.allOf(HubContentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HubContentStatus.class, HubContentStatus::toString);
    }
}

