/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MLflowConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MLflowConfiguration> {
    private static final SdkField<String> MLFLOW_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MlflowResourceArn").getter(MLflowConfiguration.getter(MLflowConfiguration::mlflowResourceArn)).setter(MLflowConfiguration.setter(Builder::mlflowResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlflowResourceArn").build()}).build();
    private static final SdkField<String> MLFLOW_EXPERIMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MlflowExperimentName").getter(MLflowConfiguration.getter(MLflowConfiguration::mlflowExperimentName)).setter(MLflowConfiguration.setter(Builder::mlflowExperimentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlflowExperimentName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MLFLOW_RESOURCE_ARN_FIELD, MLFLOW_EXPERIMENT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MLflowConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mlflowResourceArn;
    private final String mlflowExperimentName;

    private MLflowConfiguration(BuilderImpl builder) {
        this.mlflowResourceArn = builder.mlflowResourceArn;
        this.mlflowExperimentName = builder.mlflowExperimentName;
    }

    public final String mlflowResourceArn() {
        return this.mlflowResourceArn;
    }

    public final String mlflowExperimentName() {
        return this.mlflowExperimentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mlflowResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlflowExperimentName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MLflowConfiguration)) {
            return false;
        }
        MLflowConfiguration other = (MLflowConfiguration)obj;
        return Objects.equals(this.mlflowResourceArn(), other.mlflowResourceArn()) && Objects.equals(this.mlflowExperimentName(), other.mlflowExperimentName());
    }

    public final String toString() {
        return ToString.builder((String)"MLflowConfiguration").add("MlflowResourceArn", (Object)this.mlflowResourceArn()).add("MlflowExperimentName", (Object)this.mlflowExperimentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MlflowResourceArn": {
                return Optional.ofNullable(clazz.cast(this.mlflowResourceArn()));
            }
            case "MlflowExperimentName": {
                return Optional.ofNullable(clazz.cast(this.mlflowExperimentName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MlflowResourceArn", MLFLOW_RESOURCE_ARN_FIELD);
        map.put("MlflowExperimentName", MLFLOW_EXPERIMENT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MLflowConfiguration, T> g) {
        return obj -> g.apply((MLflowConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mlflowResourceArn;
        private String mlflowExperimentName;

        private BuilderImpl() {
        }

        private BuilderImpl(MLflowConfiguration model) {
            this.mlflowResourceArn(model.mlflowResourceArn);
            this.mlflowExperimentName(model.mlflowExperimentName);
        }

        public final String getMlflowResourceArn() {
            return this.mlflowResourceArn;
        }

        public final void setMlflowResourceArn(String mlflowResourceArn) {
            this.mlflowResourceArn = mlflowResourceArn;
        }

        @Override
        public final Builder mlflowResourceArn(String mlflowResourceArn) {
            this.mlflowResourceArn = mlflowResourceArn;
            return this;
        }

        public final String getMlflowExperimentName() {
            return this.mlflowExperimentName;
        }

        public final void setMlflowExperimentName(String mlflowExperimentName) {
            this.mlflowExperimentName = mlflowExperimentName;
        }

        @Override
        public final Builder mlflowExperimentName(String mlflowExperimentName) {
            this.mlflowExperimentName = mlflowExperimentName;
            return this;
        }

        public MLflowConfiguration build() {
            return new MLflowConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MLflowConfiguration> {
        public Builder mlflowResourceArn(String var1);

        public Builder mlflowExperimentName(String var1);
    }
}

