/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelRegistrationMode {
    AUTO_MODEL_REGISTRATION_ENABLED("AutoModelRegistrationEnabled"),
    AUTO_MODEL_REGISTRATION_DISABLED("AutoModelRegistrationDisabled"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelRegistrationMode> VALUE_MAP;
    private final String value;

    private ModelRegistrationMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelRegistrationMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelRegistrationMode> knownValues() {
        EnumSet<ModelRegistrationMode> knownValues = EnumSet.allOf(ModelRegistrationMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelRegistrationMode.class, ModelRegistrationMode::toString);
    }
}

