/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ComputeQuotaSummary;
import software.amazon.awssdk.services.sagemaker.model.ListComputeQuotasRequest;
import software.amazon.awssdk.services.sagemaker.model.ListComputeQuotasResponse;

public class ListComputeQuotasPublisher
implements SdkPublisher<ListComputeQuotasResponse> {
    private final SageMakerAsyncClient client;
    private final ListComputeQuotasRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListComputeQuotasPublisher(SageMakerAsyncClient client, ListComputeQuotasRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListComputeQuotasPublisher(SageMakerAsyncClient client, ListComputeQuotasRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListComputeQuotasResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListComputeQuotasResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ComputeQuotaSummary> computeQuotaSummaries() {
        Function<ListComputeQuotasResponse, Iterator> getIterator = response -> {
            if (response != null && response.computeQuotaSummaries() != null) {
                return response.computeQuotaSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListComputeQuotasResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListComputeQuotasResponseFetcher
    implements AsyncPageFetcher<ListComputeQuotasResponse> {
        private ListComputeQuotasResponseFetcher() {
        }

        public boolean hasNextPage(ListComputeQuotasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListComputeQuotasResponse> nextPage(ListComputeQuotasResponse previousPage) {
            if (previousPage == null) {
                return ListComputeQuotasPublisher.this.client.listComputeQuotas(ListComputeQuotasPublisher.this.firstRequest);
            }
            return ListComputeQuotasPublisher.this.client.listComputeQuotas((ListComputeQuotasRequest)((Object)ListComputeQuotasPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

