/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakera2iruntime.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHumanLoopsResponse extends SageMakerA2IRuntimeResponse implements
        ToCopyableBuilder<ListHumanLoopsResponse.Builder, ListHumanLoopsResponse> {
    private static final SdkField<List<HumanLoopSummary>> HUMAN_LOOP_SUMMARIES_FIELD = SdkField
            .<List<HumanLoopSummary>> builder(MarshallingType.LIST)
            .memberName("HumanLoopSummaries")
            .getter(getter(ListHumanLoopsResponse::humanLoopSummaries))
            .setter(setter(Builder::humanLoopSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HumanLoopSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(HumanLoopSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListHumanLoopsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_LOOP_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<HumanLoopSummary> humanLoopSummaries;

    private final String nextToken;

    private ListHumanLoopsResponse(BuilderImpl builder) {
        super(builder);
        this.humanLoopSummaries = builder.humanLoopSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the HumanLoopSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHumanLoopSummaries() {
        return humanLoopSummaries != null && !(humanLoopSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that contain information about the human loops.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHumanLoopSummaries} method.
     * </p>
     * 
     * @return An array of objects that contain information about the human loops.
     */
    public final List<HumanLoopSummary> humanLoopSummaries() {
        return humanLoopSummaries;
    }

    /**
     * <p>
     * A token to display the next page of results.
     * </p>
     * 
     * @return A token to display the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHumanLoopSummaries() ? humanLoopSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHumanLoopsResponse)) {
            return false;
        }
        ListHumanLoopsResponse other = (ListHumanLoopsResponse) obj;
        return hasHumanLoopSummaries() == other.hasHumanLoopSummaries()
                && Objects.equals(humanLoopSummaries(), other.humanLoopSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHumanLoopsResponse")
                .add("HumanLoopSummaries", hasHumanLoopSummaries() ? humanLoopSummaries() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanLoopSummaries":
            return Optional.ofNullable(clazz.cast(humanLoopSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHumanLoopsResponse, T> g) {
        return obj -> g.apply((ListHumanLoopsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerA2IRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListHumanLoopsResponse> {
        /**
         * <p>
         * An array of objects that contain information about the human loops.
         * </p>
         * 
         * @param humanLoopSummaries
         *        An array of objects that contain information about the human loops.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopSummaries(Collection<HumanLoopSummary> humanLoopSummaries);

        /**
         * <p>
         * An array of objects that contain information about the human loops.
         * </p>
         * 
         * @param humanLoopSummaries
         *        An array of objects that contain information about the human loops.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopSummaries(HumanLoopSummary... humanLoopSummaries);

        /**
         * <p>
         * An array of objects that contain information about the human loops.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HumanLoopSummary>.Builder} avoiding the
         * need to create one manually via {@link List<HumanLoopSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HumanLoopSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #humanLoopSummaries(List<HumanLoopSummary>)}.
         * 
         * @param humanLoopSummaries
         *        a consumer that will call methods on {@link List<HumanLoopSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopSummaries(List<HumanLoopSummary>)
         */
        Builder humanLoopSummaries(Consumer<HumanLoopSummary.Builder>... humanLoopSummaries);

        /**
         * <p>
         * A token to display the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A token to display the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerA2IRuntimeResponse.BuilderImpl implements Builder {
        private List<HumanLoopSummary> humanLoopSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHumanLoopsResponse model) {
            super(model);
            humanLoopSummaries(model.humanLoopSummaries);
            nextToken(model.nextToken);
        }

        public final List<HumanLoopSummary.Builder> getHumanLoopSummaries() {
            List<HumanLoopSummary.Builder> result = HumanLoopSummariesCopier.copyToBuilder(this.humanLoopSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHumanLoopSummaries(Collection<HumanLoopSummary.BuilderImpl> humanLoopSummaries) {
            this.humanLoopSummaries = HumanLoopSummariesCopier.copyFromBuilder(humanLoopSummaries);
        }

        @Override
        @Transient
        public final Builder humanLoopSummaries(Collection<HumanLoopSummary> humanLoopSummaries) {
            this.humanLoopSummaries = HumanLoopSummariesCopier.copy(humanLoopSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder humanLoopSummaries(HumanLoopSummary... humanLoopSummaries) {
            humanLoopSummaries(Arrays.asList(humanLoopSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder humanLoopSummaries(Consumer<HumanLoopSummary.Builder>... humanLoopSummaries) {
            humanLoopSummaries(Stream.of(humanLoopSummaries).map(c -> HumanLoopSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListHumanLoopsResponse build() {
            return new ListHumanLoopsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
