/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakeredge.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EdgeMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EdgeMetric> {
    private static final SdkField<String> DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Dimension").getter(EdgeMetric.getter(EdgeMetric::dimension)).setter(EdgeMetric.setter(Builder::dimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimension").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(EdgeMetric.getter(EdgeMetric::metricName)).setter(EdgeMetric.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<Double> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Value").getter(EdgeMetric.getter(EdgeMetric::value)).setter(EdgeMetric.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(EdgeMetric.getter(EdgeMetric::timestamp)).setter(EdgeMetric.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_FIELD, METRIC_NAME_FIELD, VALUE_FIELD, TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EdgeMetric.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dimension;
    private final String metricName;
    private final Double value;
    private final Instant timestamp;

    private EdgeMetric(BuilderImpl builder) {
        this.dimension = builder.dimension;
        this.metricName = builder.metricName;
        this.value = builder.value;
        this.timestamp = builder.timestamp;
    }

    public final String dimension() {
        return this.dimension;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final Double value() {
        return this.value;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimension());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeMetric)) {
            return false;
        }
        EdgeMetric other = (EdgeMetric)obj;
        return Objects.equals(this.dimension(), other.dimension()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"EdgeMetric").add("Dimension", (Object)this.dimension()).add("MetricName", (Object)this.metricName()).add("Value", (Object)this.value()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dimension": {
                return Optional.ofNullable(clazz.cast(this.dimension()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Dimension", DIMENSION_FIELD);
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EdgeMetric, T> g) {
        return obj -> g.apply((EdgeMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dimension;
        private String metricName;
        private Double value;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeMetric model) {
            this.dimension(model.dimension);
            this.metricName(model.metricName);
            this.value(model.value);
            this.timestamp(model.timestamp);
        }

        public final String getDimension() {
            return this.dimension;
        }

        public final void setDimension(String dimension) {
            this.dimension = dimension;
        }

        @Override
        public final Builder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final Double getValue() {
            return this.value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public EdgeMetric build() {
            return new EdgeMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EdgeMetric> {
        public Builder dimension(String var1);

        public Builder metricName(String var1);

        public Builder value(Double var1);

        public Builder timestamp(Instant var1);
    }
}

