/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifiersCopier;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.ExpirationTimeResponse;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.SageMakerFeatureStoreRuntimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetRecordRequest
extends SageMakerFeatureStoreRuntimeRequest
implements ToCopyableBuilder<Builder, BatchGetRecordRequest> {
    private static final SdkField<List<BatchGetRecordIdentifier>> IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Identifiers").getter(BatchGetRecordRequest.getter(BatchGetRecordRequest::identifiers)).setter(BatchGetRecordRequest.setter(Builder::identifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetRecordIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXPIRATION_TIME_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpirationTimeResponse").getter(BatchGetRecordRequest.getter(BatchGetRecordRequest::expirationTimeResponseAsString)).setter(BatchGetRecordRequest.setter(Builder::expirationTimeResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTimeResponse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIERS_FIELD, EXPIRATION_TIME_RESPONSE_FIELD));
    private final List<BatchGetRecordIdentifier> identifiers;
    private final String expirationTimeResponse;

    private BatchGetRecordRequest(BuilderImpl builder) {
        super(builder);
        this.identifiers = builder.identifiers;
        this.expirationTimeResponse = builder.expirationTimeResponse;
    }

    public final boolean hasIdentifiers() {
        return this.identifiers != null && !(this.identifiers instanceof SdkAutoConstructList);
    }

    public final List<BatchGetRecordIdentifier> identifiers() {
        return this.identifiers;
    }

    public final ExpirationTimeResponse expirationTimeResponse() {
        return ExpirationTimeResponse.fromValue(this.expirationTimeResponse);
    }

    public final String expirationTimeResponseAsString() {
        return this.expirationTimeResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentifiers() ? this.identifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTimeResponseAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRecordRequest)) {
            return false;
        }
        BatchGetRecordRequest other = (BatchGetRecordRequest)((Object)obj);
        return this.hasIdentifiers() == other.hasIdentifiers() && Objects.equals(this.identifiers(), other.identifiers()) && Objects.equals(this.expirationTimeResponseAsString(), other.expirationTimeResponseAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetRecordRequest").add("Identifiers", this.hasIdentifiers() ? this.identifiers() : null).add("ExpirationTimeResponse", (Object)this.expirationTimeResponseAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifiers": {
                return Optional.ofNullable(clazz.cast(this.identifiers()));
            }
            case "ExpirationTimeResponse": {
                return Optional.ofNullable(clazz.cast(this.expirationTimeResponseAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRecordRequest, T> g) {
        return obj -> g.apply((BatchGetRecordRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerFeatureStoreRuntimeRequest.BuilderImpl
    implements Builder {
        private List<BatchGetRecordIdentifier> identifiers = DefaultSdkAutoConstructList.getInstance();
        private String expirationTimeResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRecordRequest model) {
            super(model);
            this.identifiers(model.identifiers);
            this.expirationTimeResponse(model.expirationTimeResponse);
        }

        public final List<BatchGetRecordIdentifier.Builder> getIdentifiers() {
            List<BatchGetRecordIdentifier.Builder> result = BatchGetRecordIdentifiersCopier.copyToBuilder(this.identifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentifiers(Collection<BatchGetRecordIdentifier.BuilderImpl> identifiers) {
            this.identifiers = BatchGetRecordIdentifiersCopier.copyFromBuilder(identifiers);
        }

        @Override
        public final Builder identifiers(Collection<BatchGetRecordIdentifier> identifiers) {
            this.identifiers = BatchGetRecordIdentifiersCopier.copy(identifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(BatchGetRecordIdentifier ... identifiers) {
            this.identifiers(Arrays.asList(identifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(Consumer<BatchGetRecordIdentifier.Builder> ... identifiers) {
            this.identifiers(Stream.of(identifiers).map(c -> (BatchGetRecordIdentifier)((BatchGetRecordIdentifier.Builder)BatchGetRecordIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExpirationTimeResponse() {
            return this.expirationTimeResponse;
        }

        public final void setExpirationTimeResponse(String expirationTimeResponse) {
            this.expirationTimeResponse = expirationTimeResponse;
        }

        @Override
        public final Builder expirationTimeResponse(String expirationTimeResponse) {
            this.expirationTimeResponse = expirationTimeResponse;
            return this;
        }

        @Override
        public final Builder expirationTimeResponse(ExpirationTimeResponse expirationTimeResponse) {
            this.expirationTimeResponse(expirationTimeResponse == null ? null : expirationTimeResponse.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetRecordRequest build() {
            return new BatchGetRecordRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerFeatureStoreRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetRecordRequest> {
        public Builder identifiers(Collection<BatchGetRecordIdentifier> var1);

        public Builder identifiers(BatchGetRecordIdentifier ... var1);

        public Builder identifiers(Consumer<BatchGetRecordIdentifier.Builder> ... var1);

        public Builder expirationTimeResponse(String var1);

        public Builder expirationTimeResponse(ExpirationTimeResponse var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

