/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.ValueAsStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FeatureValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FeatureValue> {
    private static final SdkField<String> FEATURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureName").getter(FeatureValue.getter(FeatureValue::featureName)).setter(FeatureValue.setter(Builder::featureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureName").build()}).build();
    private static final SdkField<String> VALUE_AS_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValueAsString").getter(FeatureValue.getter(FeatureValue::valueAsString)).setter(FeatureValue.setter(Builder::valueAsString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueAsString").build()}).build();
    private static final SdkField<List<String>> VALUE_AS_STRING_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValueAsStringList").getter(FeatureValue.getter(FeatureValue::valueAsStringList)).setter(FeatureValue.setter(Builder::valueAsStringList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueAsStringList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_NAME_FIELD, VALUE_AS_STRING_FIELD, VALUE_AS_STRING_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String featureName;
    private final String valueAsString;
    private final List<String> valueAsStringList;

    private FeatureValue(BuilderImpl builder) {
        this.featureName = builder.featureName;
        this.valueAsString = builder.valueAsString;
        this.valueAsStringList = builder.valueAsStringList;
    }

    public final String featureName() {
        return this.featureName;
    }

    public final String valueAsString() {
        return this.valueAsString;
    }

    public final boolean hasValueAsStringList() {
        return this.valueAsStringList != null && !(this.valueAsStringList instanceof SdkAutoConstructList);
    }

    public final List<String> valueAsStringList() {
        return this.valueAsStringList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.featureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValueAsStringList() ? this.valueAsStringList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeatureValue)) {
            return false;
        }
        FeatureValue other = (FeatureValue)obj;
        return Objects.equals(this.featureName(), other.featureName()) && Objects.equals(this.valueAsString(), other.valueAsString()) && this.hasValueAsStringList() == other.hasValueAsStringList() && Objects.equals(this.valueAsStringList(), other.valueAsStringList());
    }

    public final String toString() {
        return ToString.builder((String)"FeatureValue").add("FeatureName", (Object)this.featureName()).add("ValueAsString", (Object)this.valueAsString()).add("ValueAsStringList", this.hasValueAsStringList() ? this.valueAsStringList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeatureName": {
                return Optional.ofNullable(clazz.cast(this.featureName()));
            }
            case "ValueAsString": {
                return Optional.ofNullable(clazz.cast(this.valueAsString()));
            }
            case "ValueAsStringList": {
                return Optional.ofNullable(clazz.cast(this.valueAsStringList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FeatureValue, T> g) {
        return obj -> g.apply((FeatureValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String featureName;
        private String valueAsString;
        private List<String> valueAsStringList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FeatureValue model) {
            this.featureName(model.featureName);
            this.valueAsString(model.valueAsString);
            this.valueAsStringList(model.valueAsStringList);
        }

        public final String getFeatureName() {
            return this.featureName;
        }

        public final void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        @Override
        public final Builder featureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        public final String getValueAsString() {
            return this.valueAsString;
        }

        public final void setValueAsString(String valueAsString) {
            this.valueAsString = valueAsString;
        }

        @Override
        public final Builder valueAsString(String valueAsString) {
            this.valueAsString = valueAsString;
            return this;
        }

        public final Collection<String> getValueAsStringList() {
            if (this.valueAsStringList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.valueAsStringList;
        }

        public final void setValueAsStringList(Collection<String> valueAsStringList) {
            this.valueAsStringList = ValueAsStringListCopier.copy(valueAsStringList);
        }

        @Override
        public final Builder valueAsStringList(Collection<String> valueAsStringList) {
            this.valueAsStringList = ValueAsStringListCopier.copy(valueAsStringList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueAsStringList(String ... valueAsStringList) {
            this.valueAsStringList(Arrays.asList(valueAsStringList));
            return this;
        }

        public FeatureValue build() {
            return new FeatureValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FeatureValue> {
        public Builder featureName(String var1);

        public Builder valueAsString(String var1);

        public Builder valueAsStringList(Collection<String> var1);

        public Builder valueAsStringList(String ... var1);
    }
}

